/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.algorithm.MaxHeap;
import com.hankcs.hanlp.mining.word2vec.Vector;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractVectorModel<K> {
    Map<K, Vector> storage;

    public AbstractVectorModel(Map<K, Vector> storage) {
        this.storage = storage;
    }

    public AbstractVectorModel() {
        this.storage = new TreeMap<K, Vector>();
    }

    public final Vector vector(K key) {
        Vector vector = this.storage.get(key);
        if (vector == null) {
            return null;
        }
        return vector;
    }

    public float similarity(K what, K with) {
        Vector vectorWhat = this.storage.get(what);
        if (vectorWhat == null) {
            return -1.0f;
        }
        Vector vectorWith = this.storage.get(with);
        if (vectorWith == null) {
            return -1.0f;
        }
        return vectorWhat.cosineForUnitVector(vectorWith);
    }

    public List<Map.Entry<K, Float>> nearest(K key, int size) {
        Vector vector = this.storage.get(key);
        if (vector == null) {
            return Collections.emptyList();
        }
        return this.nearest(key, vector, size);
    }

    private List<Map.Entry<K, Float>> nearest(K key, Vector vector, int size) {
        MaxHeap<AbstractMap.SimpleEntry<K, Float>> maxHeap = new MaxHeap<AbstractMap.SimpleEntry<K, Float>>(size, new Comparator<Map.Entry<K, Float>>(){

            @Override
            public int compare(Map.Entry<K, Float> o1, Map.Entry<K, Float> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry<K, Vector> entry : this.storage.entrySet()) {
            if (entry.getKey().equals(key)) continue;
            maxHeap.add(new AbstractMap.SimpleEntry<K, Float>(entry.getKey(), Float.valueOf(entry.getValue().cosineForUnitVector(vector))));
        }
        return maxHeap.toList();
    }

    public List<Map.Entry<K, Float>> nearest(Vector vector, int size) {
        MaxHeap<AbstractMap.SimpleEntry<K, Float>> maxHeap = new MaxHeap<AbstractMap.SimpleEntry<K, Float>>(size, new Comparator<Map.Entry<K, Float>>(){

            @Override
            public int compare(Map.Entry<K, Float> o1, Map.Entry<K, Float> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry<K, Vector> entry : this.storage.entrySet()) {
            maxHeap.add(new AbstractMap.SimpleEntry<K, Float>(entry.getKey(), Float.valueOf(entry.getValue().cosineForUnitVector(vector))));
        }
        return maxHeap.toList();
    }

    public List<Map.Entry<K, Float>> nearest(Vector vector) {
        return this.nearest(vector, 10);
    }

    public List<Map.Entry<K, Float>> nearest(K key) {
        return this.nearest(key, 10);
    }

    final List<Map.Entry<K, Float>> queryNearest(String query, int size) {
        if (query == null || query.length() == 0) {
            return Collections.emptyList();
        }
        try {
            return this.nearest(this.query(query), size);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public abstract Vector query(String var1);

    public int size() {
        return this.storage.size();
    }

    public int dimension() {
        if (this.storage == null || this.storage.isEmpty()) {
            return 0;
        }
        return this.storage.values().iterator().next().size();
    }

    public Vector remove(K key) {
        return this.storage.remove(key);
    }
}

