/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dependency.AbstractDependencyParser;
import com.hankcs.hanlp.dependency.common.Edge;
import com.hankcs.hanlp.dependency.common.Node;
import com.hankcs.hanlp.dependency.common.State;
import com.hankcs.hanlp.seg.common.Term;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public abstract class MinimumSpanningTreeParser
extends AbstractDependencyParser {
    @Override
    public CoNLLSentence parse(List<Term> termList) {
        int i;
        if (termList == null || termList.size() == 0) {
            return null;
        }
        termList.add(0, new Term("##\u6838\u5fc3##", Nature.begin));
        Node[] nodeArray = new Node[termList.size()];
        Iterator<Term> iterator = termList.iterator();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            nodeArray[i2] = new Node(iterator.next(), i2);
        }
        Edge[][] edges = new Edge[nodeArray.length][nodeArray.length];
        for (int i3 = 0; i3 < edges.length; ++i3) {
            for (int j = 0; j < edges[i3].length; ++j) {
                if (i3 == j) continue;
                edges[j][i3] = this.makeEdge(nodeArray, i3, j);
            }
        }
        int max_v = nodeArray.length * (nodeArray.length - 1);
        float[] mincost = new float[max_v];
        Arrays.fill(mincost, 1.1342745E38f);
        boolean[] used = new boolean[max_v];
        Arrays.fill(used, false);
        used[0] = true;
        PriorityQueue<State> que = new PriorityQueue<State>();
        float minCostToRoot = Float.MAX_VALUE;
        Edge firstEdge = null;
        Edge[] edgeResult = new Edge[termList.size() - 1];
        for (Edge edge : edges[0]) {
            if (edge == null || !(minCostToRoot > edge.cost)) continue;
            firstEdge = edge;
            minCostToRoot = edge.cost;
        }
        if (firstEdge == null) {
            return null;
        }
        que.add(new State(minCostToRoot, firstEdge.from, firstEdge));
        while (!que.isEmpty()) {
            State p = (State)que.poll();
            int v = p.id;
            if (used[v] || p.cost > mincost[v]) continue;
            used[v] = true;
            if (p.edge != null) {
                edgeResult[p.edge.from - 1] = p.edge;
            }
            for (Edge e : edges[v]) {
                if (e == null || !(mincost[e.from] > e.cost)) continue;
                mincost[e.from] = e.cost;
                que.add(new State(mincost[e.from], e.from, e));
            }
        }
        CoNLLWord[] wordArray = new CoNLLWord[termList.size() - 1];
        for (i = 0; i < wordArray.length; ++i) {
            wordArray[i] = new CoNLLWord(i + 1, nodeArray[i + 1].word, nodeArray[i + 1].label);
            wordArray[i].DEPREL = edgeResult[i].label;
        }
        for (i = 0; i < edgeResult.length; ++i) {
            int index = edgeResult[i].to - 1;
            wordArray[i].HEAD = index < 0 ? CoNLLWord.ROOT : wordArray[index];
        }
        return new CoNLLSentence(wordArray);
    }

    protected abstract Edge makeEdge(Node[] var1, int var2, int var3);
}

