/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.pim;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactImpl;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.ItemEnumeration;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMListImpl;
import org.kobjects.pim.VCard;

public class ContactListImpl
extends PIMListImpl
implements ContactList {
    public ContactListImpl(Hashtable contacts) {
        super(contacts);
    }

    public int[] getSupportedAttributes(int field) {
        switch (field) {
            case 115: {
                return new int[]{1, 2, 4, 8, 16, 64, 128, 256, 512};
            }
            case 100: 
            case 103: 
            case 104: 
            case 107: 
            case 110: 
            case 111: 
            case 118: {
                return new int[]{1, 8, 128, 512};
            }
        }
        return new int[0];
    }

    public int[] getSupportedArrayElements(int field) {
        if (field == 100) {
            return new int[]{0, 1, 2, 3, 4, 5};
        }
        if (field == 106) {
            return new int[]{0, 1, 2, 3, 4};
        }
        throw new RuntimeException("Not an array field");
    }

    public Contact createContact() {
        return new ContactImpl(this, new VCard());
    }

    public void removeContact(Contact contact) {
        this.items.remove(contact.getString(117, 0));
    }

    public void deleteCategory(String category) {
        throw new RuntimeException("NYI");
    }

    String attrToName(int attr) {
        switch (attr) {
            case 1: {
                return "asst";
            }
            case 2: {
                return "auto";
            }
            case 4: {
                return "fax";
            }
            case 8: {
                return "home";
            }
            case 16: {
                return "mobile";
            }
            case 64: {
                return "pager";
            }
            case 128: {
                return "pref";
            }
            case 256: {
                return "sms";
            }
            case 512: {
                return "work";
            }
        }
        throw new RuntimeException("illegatl attr!");
    }

    String fieldToName(int id) {
        switch (id) {
            case 100: {
                return "adr";
            }
            case 106: {
                return "n";
            }
            case 105: {
                return "fn";
            }
            case 109: {
                return "org";
            }
            case 115: {
                return "tel";
            }
            case 103: {
                return "email";
            }
            case 117: {
                return "uid";
            }
            case 118: {
                return "url";
            }
            case 107: {
                return "nickname";
            }
        }
        throw new RuntimeException("Unknown ID:" + id);
    }

    public String getFieldLabel(int fieldID) {
        switch (fieldID) {
            case 101: {
                return "Birthday";
            }
            case 109: {
                return "Organization";
            }
            case 103: {
                return "Email";
            }
            case 106: {
                return "Name";
            }
            case 105: {
                return "Formatted Name";
            }
            case 107: {
                return "Nickname";
            }
            case 108: {
                return "Note";
            }
            case 110: {
                return "Photo";
            }
            case 112: {
                return "Public Key";
            }
            case 114: {
                return "Revision";
            }
            case 115: {
                return "Telephone";
            }
            case 116: {
                return "Title";
            }
            case 117: {
                return "UID";
            }
            case 118: {
                return "URL";
            }
        }
        return this.fieldToName(fieldID);
    }

    public int[] getSupportedFields() {
        return new int[]{117, 105, 107, 106, 100, 115, 103, 118};
    }

    public boolean isSupportedArrayElement(int i, int j) {
        return j >= 0 && (i == 106 && j < 5 || i == 100 && j < 6);
    }

    public Contact importContact(Contact contact) {
        throw new RuntimeException("NYI");
    }

    public int supportsCustomLabels(int field) {
        return 0;
    }

    public Enumeration items() {
        return new ItemEnumeration(this, PIM.pim.contacts.elements(), null, null, null);
    }

    public Enumeration items(String s) {
        return new ItemEnumeration(this, PIM.pim.contacts.elements(), null, s, null);
    }

    public Enumeration itemsByCategory(String category) {
        return new ItemEnumeration(this, PIM.pim.contacts.elements(), null, null, category);
    }

    public Enumeration items(PIMItem matching) {
        return new ItemEnumeration(this, PIM.pim.contacts.elements(), matching, null, null);
    }

    public String getArrayElementLabel(int fieldId, int index) {
        if (fieldId == 106) {
            switch (index) {
                case 3: {
                    return "Name Prefix";
                }
                case 1: {
                    return "Given Name";
                }
                case 2: {
                    return "Other Name";
                }
                case 0: {
                    return "Family Name";
                }
                case 4: {
                    return "Name Suffix";
                }
            }
        } else if (fieldId == 100) {
            switch (index) {
                case 2: {
                    return "Street";
                }
                case 0: {
                    return "PoBox";
                }
                case 5: {
                    return "ZIP";
                }
                case 3: {
                    return "City";
                }
                case 4: {
                    return "Region";
                }
                case 6: {
                    return "Country";
                }
                case 1: {
                    return "Extra";
                }
            }
        }
        throw new RuntimeException("illegal field or array element " + this.getFieldLabel(fieldId) + " index " + index);
    }

    public String getAttributeLabel(int attribute) {
        switch (attribute) {
            case 1: {
                return "Assistant";
            }
            case 2: {
                return "Auto";
            }
            case 4: {
                return "Fax";
            }
            case 8: {
                return "Home";
            }
            case 16: {
                return "Mobile";
            }
            case 0: {
                return "None";
            }
            case 32: {
                return "Other";
            }
            case 64: {
                return "Pager";
            }
            case 128: {
                return "Pref.";
            }
            case 256: {
                return "SMS";
            }
            case 512: {
                return "Work";
            }
        }
        throw new RuntimeException("Unknown ATTR");
    }

    public int getFieldDataType(int field) {
        switch (field) {
            case 101: {
                return 2;
            }
            case 100: 
            case 106: {
                return 5;
            }
            case 110: 
            case 112: {
                return 0;
            }
        }
        return 4;
    }

    public int maxValues(int field) {
        switch (field) {
            case 105: 
            case 106: 
            case 117: {
                return 1;
            }
        }
        return 1024;
    }
}

