/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rundeck.client.api.model.DateInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiToken {
    private String id;
    private String token;
    private String user;
    private String creator;
    private List<String> roles;
    private Boolean expired;
    private DateInfo expiration;

    public String toString() {
        return "API Token: " + this.getTruncatedIdOrToken();
    }

    public String toFullString() {
        return "API Token: " + this.id;
    }

    public String getTruncatedId() {
        return this.id != null ? this.id.substring(0, 5) + "*****" : null;
    }

    public String getTruncatedIdOrToken() {
        return this.id != null ? this.id.substring(0, 5) + "*****" : (null != this.token ? this.token.substring(0, 5) + "*****" : "?");
    }

    public String getId() {
        return this.id;
    }

    public String getIdOrToken() {
        return this.id != null ? this.id : (this.token != null ? this.token : "?");
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user", this.getUser());
        if (null != this.getRoles() && !this.getRoles().isEmpty()) {
            map.put("roles", this.getRoles());
        }
        if (null != this.getId()) {
            map.put("id", this.getId());
        }
        if (null != this.getToken()) {
            map.put("token", this.getToken());
        }
        if (null != this.getCreator()) {
            map.put("creator", this.getCreator());
        }
        if (null != this.getExpiration()) {
            map.put("expiration", this.getExpiration().date);
        }
        if (null != this.getExpired()) {
            map.put("expired", this.getExpired());
        }
        return map;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Boolean getExpired() {
        return this.expired;
    }

    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    public DateInfo getExpiration() {
        return this.expiration;
    }

    public void setExpiration(DateInfo expiration) {
        this.expiration = expiration;
    }
}

