/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import java.util.Arrays;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.FilteringHeaderResponse;
import org.apache.wicket.markup.head.filter.JavaScriptAcceptingHeaderResponseFilter;
import org.apache.wicket.markup.head.filter.OppositeHeaderResponseFilter;

public class JavaScriptFilteredIntoFooterHeaderResponse
extends FilteringHeaderResponse {
    public JavaScriptFilteredIntoFooterHeaderResponse(IHeaderResponse response, String footerBucketName) {
        super(response);
        this.setFilters(this.createFilters(footerBucketName));
    }

    private Iterable<? extends FilteringHeaderResponse.IHeaderResponseFilter> createFilters(String footerBucketName) {
        FilteringHeaderResponse.IHeaderResponseFilter footer = this.createFooterFilter(footerBucketName);
        FilteringHeaderResponse.IHeaderResponseFilter header = this.createHeaderFilter("wicket-default-header-filter", footer);
        return Arrays.asList(header, footer);
    }

    protected FilteringHeaderResponse.IHeaderResponseFilter createFooterFilter(String footerBucketName) {
        return new JavaScriptAcceptingHeaderResponseFilter(footerBucketName);
    }

    protected FilteringHeaderResponse.IHeaderResponseFilter createHeaderFilter(String headerFilterName, FilteringHeaderResponse.IHeaderResponseFilter footerFilter) {
        return new OppositeHeaderResponseFilter(headerFilterName, footerFilter);
    }
}

