/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.debugbar;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.SessionSizeDebugPanel;
import org.apache.wicket.devutils.debugbar.StandardDebugPanel;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Bytes;

public class PageSizeDebugPanel
extends StandardDebugPanel {
    private static final long serialVersionUID = 1L;
    public static final IDebugBarContributor DEBUG_BAR_CONTRIB = new IDebugBarContributor(){
        private static final long serialVersionUID = 1L;

        @Override
        public Component createComponent(String id, DebugBar debugBar) {
            return new PageSizeDebugPanel(id);
        }
    };

    public PageSizeDebugPanel(String id) {
        super(id);
    }

    @Override
    protected Class<? extends Page> getLinkPageClass() {
        return WebPage.class;
    }

    @Override
    protected BookmarkablePageLink<Void> createLink(String id) {
        BookmarkablePageLink<Void> bookmarkablePageLink = super.createLink(id);
        bookmarkablePageLink.setEnabled(false);
        return bookmarkablePageLink;
    }

    @Override
    protected ResourceReference getImageResourceReference() {
        return new PackageResourceReference(SessionSizeDebugPanel.class, "harddrive.png");
    }

    @Override
    protected IModel<String> getDataModel() {
        return new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Page enclosingPage = PageSizeDebugPanel.this.getPage();
                long pageSize = WicketObjects.sizeof((Serializable)enclosingPage);
                Bytes pageSizeInBytes = pageSize > -1L ? Bytes.bytes((long)pageSize) : null;
                String pageSizeAsString = pageSizeInBytes != null ? pageSizeInBytes.toString() : "unknown";
                return "Page: " + pageSizeAsString;
            }
        };
    }
}

