/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.osgi.annotation.versioning.ProviderType;

public class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_Dynamic = 17;
    public static final int CONSTANT_InvokeDynamic = 18;
    public static final int CONSTANT_Module = 19;
    public static final int CONSTANT_Package = 20;
    final Object[] pool;

    public ConstantPool(Object[] pool) {
        this.pool = pool;
    }

    public int size() {
        return this.pool.length;
    }

    public <T> T entry(int index) {
        return (T)this.pool[index];
    }

    public int tag(int index) {
        Object entry = this.entry(index);
        if (entry instanceof Info) {
            return ((Info)entry).tag();
        }
        if (entry instanceof String) {
            return 1;
        }
        if (entry instanceof Integer) {
            return 3;
        }
        if (entry instanceof Long) {
            return 5;
        }
        if (entry instanceof Float) {
            return 4;
        }
        if (entry instanceof Double) {
            return 6;
        }
        return 0;
    }

    public String utf8(int utf8_index) {
        return (String)this.entry(utf8_index);
    }

    public String className(int class_info_index) {
        ClassInfo classInfo = (ClassInfo)this.entry(class_info_index);
        return this.utf8(classInfo.class_index);
    }

    public String moduleName(int module_info_index) {
        ModuleInfo moduleInfo = (ModuleInfo)this.entry(module_info_index);
        return this.utf8(moduleInfo.name_index);
    }

    public String packageName(int package_info_index) {
        PackageInfo packageInfo = (PackageInfo)this.entry(package_info_index);
        return this.utf8(packageInfo.name_index);
    }

    public String string(int string_info_index) {
        StringInfo stringInfo = (StringInfo)this.entry(string_info_index);
        return this.utf8(stringInfo.string_index);
    }

    public String toString() {
        return Arrays.toString(this.pool);
    }

    public static ConstantPool read(DataInput in) throws IOException {
        int constant_pool_count = in.readUnsignedShort();
        Object[] pool = new Object[constant_pool_count];
        block19: for (int index = 1; index < constant_pool_count; ++index) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 1: {
                    pool[index] = ConstantPool.readUtf8Info(in);
                    continue block19;
                }
                case 3: {
                    pool[index] = ConstantPool.readIntegerInfo(in);
                    continue block19;
                }
                case 4: {
                    pool[index] = ConstantPool.readFloatInfo(in);
                    continue block19;
                }
                case 5: {
                    pool[index] = ConstantPool.readLongInfo(in);
                    ++index;
                    continue block19;
                }
                case 6: {
                    pool[index] = ConstantPool.readDoubleInfo(in);
                    ++index;
                    continue block19;
                }
                case 7: {
                    pool[index] = ClassInfo.read(in);
                    continue block19;
                }
                case 8: {
                    pool[index] = StringInfo.read(in);
                    continue block19;
                }
                case 9: {
                    pool[index] = FieldrefInfo.read(in);
                    continue block19;
                }
                case 10: {
                    pool[index] = MethodrefInfo.read(in);
                    continue block19;
                }
                case 11: {
                    pool[index] = InterfaceMethodrefInfo.read(in);
                    continue block19;
                }
                case 12: {
                    pool[index] = NameAndTypeInfo.read(in);
                    continue block19;
                }
                case 15: {
                    pool[index] = MethodHandleInfo.read(in);
                    continue block19;
                }
                case 16: {
                    pool[index] = MethodTypeInfo.read(in);
                    continue block19;
                }
                case 17: {
                    pool[index] = DynamicInfo.read(in);
                    continue block19;
                }
                case 18: {
                    pool[index] = InvokeDynamicInfo.read(in);
                    continue block19;
                }
                case 19: {
                    pool[index] = ModuleInfo.read(in);
                    continue block19;
                }
                case 20: {
                    pool[index] = PackageInfo.read(in);
                    continue block19;
                }
                default: {
                    throw new IOException("Unrecognized constant pool tag value " + tag + " at index " + index);
                }
            }
        }
        ConstantPool constant_pool = new ConstantPool(pool);
        return constant_pool;
    }

    static String readUtf8Info(DataInput in) throws IOException {
        String constant = in.readUTF();
        return constant.intern();
    }

    static void writeUtf8Info(DataOutput out, String constant) throws IOException {
        out.writeByte(1);
        out.writeUTF(constant);
    }

    static Integer readIntegerInfo(DataInput in) throws IOException {
        int constant = in.readInt();
        return constant;
    }

    static void writeIntegerInfo(DataOutput out, Integer constant) throws IOException {
        out.writeByte(3);
        out.writeInt(constant);
    }

    static Float readFloatInfo(DataInput in) throws IOException {
        float constant = in.readFloat();
        return Float.valueOf(constant);
    }

    static void writeFloatInfo(DataOutput out, Float constant) throws IOException {
        out.writeByte(4);
        out.writeFloat(constant.floatValue());
    }

    static Long readLongInfo(DataInput in) throws IOException {
        long constant = in.readLong();
        return constant;
    }

    static void writeLongInfo(DataOutput out, Long constant) throws IOException {
        out.writeByte(5);
        out.writeLong(constant);
    }

    static Double readDoubleInfo(DataInput in) throws IOException {
        double constant = in.readDouble();
        return constant;
    }

    static void writeDoubleInfo(DataOutput out, Double constant) throws IOException {
        out.writeByte(6);
        out.writeDouble(constant);
    }

    protected <I> int index(Class<I> infoType, Predicate<I> match, Supplier<I> supplier) {
        int len = this.size();
        for (int index = 1; index < len; ++index) {
            Object entry = this.entry(index);
            if (!infoType.isInstance(entry) || !match.test(infoType.cast(entry))) continue;
            return index;
        }
        return this.add(infoType, supplier);
    }

    protected <I> int add(Class<I> infoType, Supplier<I> supplier) {
        throw new UnsupportedOperationException("Constant Pool is not writeable; trying to add entry of type " + infoType);
    }

    public int integerInfo(int constant) {
        return this.index(Integer.class, other -> ConstantPool.equalsInteger(constant, other), () -> constant);
    }

    public int integerInfo(Integer constant) {
        int const_value = constant;
        return this.index(Integer.class, other -> ConstantPool.equalsInteger(const_value, other), () -> constant);
    }

    public int integerInfo(Byte constant) {
        return this.integerInfo(constant.intValue());
    }

    public int integerInfo(Character constant) {
        return this.integerInfo((int)constant.charValue());
    }

    public int integerInfo(Short constant) {
        return this.integerInfo(constant.intValue());
    }

    public int integerInfo(Boolean constant) {
        return this.integerInfo(constant != false ? 1 : 0);
    }

    private static boolean equalsInteger(int a, int b) {
        return a == b;
    }

    public int longInfo(Long constant) {
        long const_value = constant;
        return this.index(Long.class, other -> ConstantPool.equalsLong(const_value, other), () -> constant);
    }

    public int longInfo(long constant) {
        return this.index(Long.class, other -> ConstantPool.equalsLong(constant, other), () -> constant);
    }

    private static boolean equalsLong(long a, long b) {
        return a == b;
    }

    public int floatInfo(Float constant) {
        float const_value = constant.floatValue();
        return this.index(Float.class, other -> ConstantPool.equalsFloat(const_value, other.floatValue()), () -> constant);
    }

    public int floatInfo(float constant) {
        return this.index(Float.class, other -> ConstantPool.equalsFloat(constant, other.floatValue()), () -> Float.valueOf(constant));
    }

    private static boolean equalsFloat(float a, float b) {
        return Float.compare(a, b) == 0;
    }

    public int doubleInfo(Double constant) {
        double const_value = constant;
        return this.index(Double.class, other -> ConstantPool.equalsDouble(const_value, other), () -> constant);
    }

    public int doubleInfo(double constant) {
        return this.index(Double.class, other -> ConstantPool.equalsDouble(constant, other), () -> constant);
    }

    private static boolean equalsDouble(double a, double b) {
        return Double.compare(a, b) == 0;
    }

    public int utf8Info(String utf8) {
        Objects.requireNonNull(utf8);
        return this.index(String.class, utf8::equals, () -> utf8.intern());
    }

    public int stringInfo(String string) {
        Objects.requireNonNull(string);
        return this.index(StringInfo.class, other -> this.equalsStringInfo(string, (StringInfo)other), () -> new StringInfo(this.utf8Info(string)));
    }

    private boolean equalsStringInfo(String string, StringInfo stringInfo) {
        return string.equals(this.entry(stringInfo.string_index));
    }

    public int moduleInfo(String module_name) {
        Objects.requireNonNull(module_name);
        return this.index(ModuleInfo.class, other -> this.equalsModuleInfo(module_name, (ModuleInfo)other), () -> new ModuleInfo(this.utf8Info(module_name)));
    }

    private boolean equalsModuleInfo(String module_name, ModuleInfo moduleInfo) {
        return module_name.equals(this.entry(moduleInfo.name_index));
    }

    public int packageInfo(String package_name) {
        Objects.requireNonNull(package_name);
        return this.index(PackageInfo.class, other -> this.equalsPackageInfo(package_name, (PackageInfo)other), () -> new PackageInfo(this.utf8Info(package_name)));
    }

    private boolean equalsPackageInfo(String package_name, PackageInfo packageInfo) {
        return package_name.equals(this.entry(packageInfo.name_index));
    }

    public int classInfo(String class_name) {
        Objects.requireNonNull(class_name);
        return this.index(ClassInfo.class, other -> this.equalsClassInfo(class_name, (ClassInfo)other), () -> new ClassInfo(this.utf8Info(class_name)));
    }

    private boolean equalsClassInfo(String class_name, ClassInfo classInfo) {
        return class_name.equals(this.entry(classInfo.class_index));
    }

    public int fieldrefInfo(String class_name, String name, String descriptor) {
        Objects.requireNonNull(class_name);
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        return this.index(FieldrefInfo.class, other -> this.equalsAbstractRefInfo(class_name, name, descriptor, (AbstractRefInfo)other), () -> new FieldrefInfo(this.classInfo(class_name), this.nameAndTypeInfo(name, descriptor)));
    }

    private boolean equalsAbstractRefInfo(String class_name, String name, String descriptor, AbstractRefInfo refInfo) {
        return this.equalsClassInfo(class_name, (ClassInfo)this.entry(refInfo.class_index)) && this.equalsNameAndTypeInfo(name, descriptor, (NameAndTypeInfo)this.entry(refInfo.name_and_type_index));
    }

    public int methodrefInfo(String class_name, String name, String descriptor) {
        Objects.requireNonNull(class_name);
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        return this.index(MethodrefInfo.class, other -> this.equalsAbstractRefInfo(class_name, name, descriptor, (AbstractRefInfo)other), () -> new MethodrefInfo(this.classInfo(class_name), this.nameAndTypeInfo(name, descriptor)));
    }

    public int interfaceMethodrefInfo(String class_name, String name, String descriptor) {
        Objects.requireNonNull(class_name);
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        return this.index(InterfaceMethodrefInfo.class, other -> this.equalsAbstractRefInfo(class_name, name, descriptor, (AbstractRefInfo)other), () -> new InterfaceMethodrefInfo(this.classInfo(class_name), this.nameAndTypeInfo(name, descriptor)));
    }

    public int nameAndTypeInfo(String name, String descriptor) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        return this.index(NameAndTypeInfo.class, other -> this.equalsNameAndTypeInfo(name, descriptor, (NameAndTypeInfo)other), () -> new NameAndTypeInfo(this.utf8Info(name), this.utf8Info(descriptor)));
    }

    private boolean equalsNameAndTypeInfo(String name, String descriptor, NameAndTypeInfo nameAndTypeInfo) {
        return name.equals(this.entry(nameAndTypeInfo.name_index)) && descriptor.equals(this.entry(nameAndTypeInfo.descriptor_index));
    }

    public int methodHandleInfo(int reference_kind, String class_name, String name, String descriptor, RefInfoFunction refInfoFunction) {
        Objects.requireNonNull(class_name);
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(refInfoFunction);
        return this.index(MethodHandleInfo.class, other -> this.equalsMethodHandleInfo(reference_kind, class_name, name, descriptor, (MethodHandleInfo)other), () -> new MethodHandleInfo(reference_kind, refInfoFunction.index(class_name, name, descriptor)));
    }

    private boolean equalsMethodHandleInfo(int reference_kind, String class_name, String name, String descriptor, MethodHandleInfo methodHandleInfo) {
        return ConstantPool.equalsInteger(reference_kind, methodHandleInfo.reference_index) && this.equalsAbstractRefInfo(class_name, name, descriptor, (AbstractRefInfo)this.entry(methodHandleInfo.reference_index));
    }

    public int methodTypeInfo(String descriptor) {
        Objects.requireNonNull(descriptor);
        return this.index(MethodTypeInfo.class, other -> this.equalsMethodTypeInfo(descriptor, (MethodTypeInfo)other), () -> new MethodTypeInfo(this.utf8Info(descriptor)));
    }

    private boolean equalsMethodTypeInfo(String descriptor, MethodTypeInfo methodTypeInfo) {
        return descriptor.equals(this.entry(methodTypeInfo.descriptor_index));
    }

    public int dynamicInfo(int bootstrap_method_attr_index, String name, String descriptor) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        return this.index(DynamicInfo.class, other -> this.equalsAbstractDynamicInfo(bootstrap_method_attr_index, name, descriptor, (AbstractDynamicInfo)other), () -> new DynamicInfo(bootstrap_method_attr_index, this.nameAndTypeInfo(name, descriptor)));
    }

    private boolean equalsAbstractDynamicInfo(int bootstrap_method_attr_index, String name, String descriptor, AbstractDynamicInfo abstractDynamicInfo) {
        return ConstantPool.equalsInteger(bootstrap_method_attr_index, abstractDynamicInfo.bootstrap_method_attr_index) && this.equalsNameAndTypeInfo(name, descriptor, (NameAndTypeInfo)this.entry(abstractDynamicInfo.name_and_type_index));
    }

    public int invokeDynamicInfo(int bootstrap_method_attr_index, String name, String descriptor) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(descriptor);
        return this.index(InvokeDynamicInfo.class, other -> this.equalsAbstractDynamicInfo(bootstrap_method_attr_index, name, descriptor, (AbstractDynamicInfo)other), () -> new InvokeDynamicInfo(bootstrap_method_attr_index, this.nameAndTypeInfo(name, descriptor)));
    }

    public void write(DataOutput out) throws IOException {
        int constant_pool_count = this.size();
        out.writeShort(constant_pool_count);
        for (int index = 1; index < constant_pool_count; ++index) {
            Object entry = this.entry(index);
            if (entry instanceof Info) {
                ((Info)entry).write(out);
                continue;
            }
            if (entry instanceof String) {
                ConstantPool.writeUtf8Info(out, (String)entry);
                continue;
            }
            if (entry instanceof Integer) {
                ConstantPool.writeIntegerInfo(out, (Integer)entry);
                continue;
            }
            if (entry instanceof Long) {
                ConstantPool.writeLongInfo(out, (Long)entry);
                ++index;
                continue;
            }
            if (entry instanceof Float) {
                ConstantPool.writeFloatInfo(out, (Float)entry);
                continue;
            }
            if (entry instanceof Double) {
                ConstantPool.writeDoubleInfo(out, (Double)entry);
                ++index;
                continue;
            }
            throw new IOException("Unrecognized constant pool entry " + entry + " at index " + index);
        }
    }

    @ProviderType
    public static interface Info {
        public int tag();

        public void write(DataOutput var1) throws IOException;
    }

    public static class ClassInfo
    implements Info {
        public final int class_index;

        public ClassInfo(int class_index) {
            this.class_index = class_index;
        }

        static ClassInfo read(DataInput in) throws IOException {
            int name_index = in.readUnsignedShort();
            return new ClassInfo(name_index);
        }

        @Override
        public int tag() {
            return 7;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.class_index);
        }

        public String toString() {
            return "ClassInfo:" + this.class_index;
        }
    }

    public static class ModuleInfo
    implements Info {
        public final int name_index;

        public ModuleInfo(int name_index) {
            this.name_index = name_index;
        }

        static ModuleInfo read(DataInput in) throws IOException {
            int name_index = in.readUnsignedShort();
            return new ModuleInfo(name_index);
        }

        @Override
        public int tag() {
            return 19;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.name_index);
        }

        public String toString() {
            return "ModuleInfo:" + this.name_index;
        }
    }

    public static class PackageInfo
    implements Info {
        public final int name_index;

        public PackageInfo(int name_index) {
            this.name_index = name_index;
        }

        static PackageInfo read(DataInput in) throws IOException {
            int name_index = in.readUnsignedShort();
            return new PackageInfo(name_index);
        }

        @Override
        public int tag() {
            return 20;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.name_index);
        }

        public String toString() {
            return "PackageInfo:" + this.name_index;
        }
    }

    public static class StringInfo
    implements Info {
        public final int string_index;

        public StringInfo(int string_index) {
            this.string_index = string_index;
        }

        static StringInfo read(DataInput in) throws IOException {
            int string_index = in.readUnsignedShort();
            return new StringInfo(string_index);
        }

        @Override
        public int tag() {
            return 8;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.string_index);
        }

        public String toString() {
            return "StringInfo:" + this.string_index;
        }
    }

    public static class FieldrefInfo
    extends AbstractRefInfo {
        public FieldrefInfo(int class_index, int name_and_type_index) {
            super(class_index, name_and_type_index);
        }

        static FieldrefInfo read(DataInput in) throws IOException {
            return AbstractRefInfo.read(in, FieldrefInfo::new);
        }

        @Override
        public int tag() {
            return 9;
        }

        public String toString() {
            return "FieldrefInfo:" + this.class_index + ":" + this.name_and_type_index;
        }
    }

    public static class MethodrefInfo
    extends AbstractRefInfo {
        public MethodrefInfo(int class_index, int name_and_type_index) {
            super(class_index, name_and_type_index);
        }

        static MethodrefInfo read(DataInput in) throws IOException {
            return AbstractRefInfo.read(in, MethodrefInfo::new);
        }

        @Override
        public int tag() {
            return 10;
        }

        public String toString() {
            return "MethodrefInfo:" + this.class_index + ":" + this.name_and_type_index;
        }
    }

    public static class InterfaceMethodrefInfo
    extends AbstractRefInfo {
        public InterfaceMethodrefInfo(int class_index, int name_and_type_index) {
            super(class_index, name_and_type_index);
        }

        static InterfaceMethodrefInfo read(DataInput in) throws IOException {
            return AbstractRefInfo.read(in, InterfaceMethodrefInfo::new);
        }

        @Override
        public int tag() {
            return 11;
        }

        public String toString() {
            return "InterfaceMethodrefInfo:" + this.class_index + ":" + this.name_and_type_index;
        }
    }

    public static class NameAndTypeInfo
    implements Info {
        public final int name_index;
        public final int descriptor_index;

        public NameAndTypeInfo(int name_index, int descriptor_index) {
            this.name_index = name_index;
            this.descriptor_index = descriptor_index;
        }

        static NameAndTypeInfo read(DataInput in) throws IOException {
            int name_index = in.readUnsignedShort();
            int descriptor_index = in.readUnsignedShort();
            return new NameAndTypeInfo(name_index, descriptor_index);
        }

        @Override
        public int tag() {
            return 12;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.name_index);
            out.writeShort(this.descriptor_index);
        }

        public String toString() {
            return "NameAndTypeInfo:" + this.name_index + ":" + this.descriptor_index;
        }
    }

    public static class MethodHandleInfo
    implements Info {
        public static final int REF_getField = 1;
        public static final int REF_getStatic = 2;
        public static final int REF_putField = 3;
        public static final int REF_putStatic = 4;
        public static final int REF_invokeVirtual = 5;
        public static final int REF_invokeStatic = 6;
        public static final int REF_invokeSpecial = 7;
        public static final int REF_newInvokeSpecial = 8;
        public static final int REF_invokeInterface = 9;
        public final int reference_kind;
        public final int reference_index;

        public MethodHandleInfo(int reference_kind, int reference_index) {
            this.reference_kind = reference_kind;
            this.reference_index = reference_index;
        }

        static MethodHandleInfo read(DataInput in) throws IOException {
            int reference_kind = in.readUnsignedByte();
            int reference_index = in.readUnsignedShort();
            return new MethodHandleInfo(reference_kind, reference_index);
        }

        @Override
        public int tag() {
            return 15;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeByte(this.reference_kind);
            out.writeShort(this.reference_index);
        }

        public String toString() {
            return "MethodHandleInfo:" + this.reference_kind + ":" + this.reference_index;
        }
    }

    public static class MethodTypeInfo
    implements Info {
        public final int descriptor_index;

        public MethodTypeInfo(int descriptor_index) {
            this.descriptor_index = descriptor_index;
        }

        static MethodTypeInfo read(DataInput in) throws IOException {
            int descriptor_index = in.readUnsignedShort();
            return new MethodTypeInfo(descriptor_index);
        }

        @Override
        public int tag() {
            return 16;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.descriptor_index);
        }

        public String toString() {
            return "MethodTypeInfo:" + this.descriptor_index;
        }
    }

    public static class DynamicInfo
    extends AbstractDynamicInfo {
        public DynamicInfo(int bootstrap_method_attr_index, int name_and_type_index) {
            super(bootstrap_method_attr_index, name_and_type_index);
        }

        static DynamicInfo read(DataInput in) throws IOException {
            return AbstractDynamicInfo.read(in, DynamicInfo::new);
        }

        @Override
        public int tag() {
            return 17;
        }

        public String toString() {
            return "DynamicInfo:" + this.bootstrap_method_attr_index + ":" + this.name_and_type_index;
        }
    }

    public static class InvokeDynamicInfo
    extends AbstractDynamicInfo {
        public InvokeDynamicInfo(int bootstrap_method_attr_index, int name_and_type_index) {
            super(bootstrap_method_attr_index, name_and_type_index);
        }

        static InvokeDynamicInfo read(DataInput in) throws IOException {
            return AbstractDynamicInfo.read(in, InvokeDynamicInfo::new);
        }

        @Override
        public int tag() {
            return 18;
        }

        public String toString() {
            return "InvokeDynamicInfo:" + this.bootstrap_method_attr_index + ":" + this.name_and_type_index;
        }
    }

    public static abstract class AbstractRefInfo
    implements Info {
        public final int class_index;
        public final int name_and_type_index;

        protected AbstractRefInfo(int class_index, int name_and_type_index) {
            this.class_index = class_index;
            this.name_and_type_index = name_and_type_index;
        }

        static <R extends AbstractRefInfo> R read(DataInput in, Constructor<R> constructor) throws IOException {
            int class_index = in.readUnsignedShort();
            int name_and_type_index = in.readUnsignedShort();
            return constructor.init(class_index, name_and_type_index);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.class_index);
            out.writeShort(this.name_and_type_index);
        }

        @FunctionalInterface
        public static interface Constructor<R extends AbstractRefInfo> {
            public R init(int var1, int var2);
        }
    }

    @FunctionalInterface
    public static interface RefInfoFunction {
        public int index(String var1, String var2, String var3);
    }

    public static abstract class AbstractDynamicInfo
    implements Info {
        public final int bootstrap_method_attr_index;
        public final int name_and_type_index;

        protected AbstractDynamicInfo(int bootstrap_method_attr_index, int name_and_type_index) {
            this.bootstrap_method_attr_index = bootstrap_method_attr_index;
            this.name_and_type_index = name_and_type_index;
        }

        static <D extends AbstractDynamicInfo> D read(DataInput in, Constructor<D> constructor) throws IOException {
            int bootstrap_method_attr_index = in.readUnsignedShort();
            int name_and_type_index = in.readUnsignedShort();
            return constructor.init(bootstrap_method_attr_index, name_and_type_index);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeByte(this.tag());
            out.writeShort(this.bootstrap_method_attr_index);
            out.writeShort(this.name_and_type_index);
        }

        @FunctionalInterface
        public static interface Constructor<D extends AbstractDynamicInfo> {
            public D init(int var1, int var2);
        }
    }
}

