/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.math.BigDecimal;
import java.util.Arrays;
import org.hsqldb.map.ValuePoolHashMap;

public final class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static final int SPACE_STRING_SIZE = 64;
    static final int DEFAULT_VALUE_POOL_SIZE = 4096;
    static final int[] defaultPoolLookupSize;
    static final int POOLS_COUNT;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    public static final String spaceString;
    public static final Integer INTEGER_0;
    public static final Integer INTEGER_1;
    public static final Integer INTEGER_2;
    public static final Integer INTEGER_MAX;
    public static final BigDecimal BIG_DECIMAL_0;
    public static final BigDecimal BIG_DECIMAL_1;
    public static final String[] emptyStringArray;
    public static final Object[] emptyObjectArray;
    public static final int[] emptyIntArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] nArray = defaultPoolLookupSize;
        int n = 2;
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i = 0; i < POOLS_COUNT; ++i) {
                int n2 = nArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(n2, n2 * n, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static int getMaxStringLength() {
        return maxStringLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool() {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        Class<ValuePool> clazz = ValuePool.class;
        synchronized (ValuePool.class) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int n) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            return intPool.getOrAddInteger(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long l) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            return longPool.getOrAddLong(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long l) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            return doublePool.getOrAddDouble(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String string) {
        if (string == null || string.length() > maxStringLength) {
            return string;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSubString(String string, int n, int n2) {
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(string.substring(n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            return (BigDecimal)bigdecimalPool.getOrAddObject(bigDecimal);
        }
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        defaultPoolLookupSize = new int[]{4096, 4096, 4096, 4096, 4096};
        POOLS_COUNT = defaultPoolLookupSize.length;
        char[] cArray = new char[64];
        Arrays.fill(cArray, ' ');
        spaceString = new String(cArray);
        ValuePool.initPool();
        INTEGER_0 = ValuePool.getInt(0);
        INTEGER_1 = ValuePool.getInt(1);
        INTEGER_2 = ValuePool.getInt(2);
        INTEGER_MAX = ValuePool.getInt(Integer.MAX_VALUE);
        BIG_DECIMAL_0 = ValuePool.getBigDecimal(BigDecimal.valueOf(0L));
        BIG_DECIMAL_1 = ValuePool.getBigDecimal(new BigDecimal(1));
        emptyStringArray = new String[0];
        emptyObjectArray = new Object[0];
        emptyIntArray = new int[0];
    }
}

