/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.transaction.BeanTransactionPolicy;
import org.apache.openejb.core.transaction.TransactionPolicy;

public class EjbUserTransaction
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = 8369364873055306924L;

    public void begin() throws NotSupportedException, SystemException {
        this.getUserTransaction().begin();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.getUserTransaction().commit();
    }

    public int getStatus() throws SystemException {
        return this.getUserTransaction().getStatus();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getUserTransaction().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getUserTransaction().setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
        this.getUserTransaction().setTransactionTimeout(i);
    }

    private UserTransaction getUserTransaction() throws SystemException {
        TransactionPolicy txPolicy;
        ThreadContext callContext = ThreadContext.getThreadContext();
        if (callContext != null && (txPolicy = callContext.getTransactionPolicy()) != null && txPolicy instanceof BeanTransactionPolicy) {
            BeanTransactionPolicy beanTxEnv = (BeanTransactionPolicy)txPolicy;
            return beanTxEnv.getUserTransaction();
        }
        throw new SystemException("Current thread context does not contain a bean-managed transaction environment");
    }
}

