/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.metadata.resolver.filter.data.impl.MetadataSource;
import org.slf4j.Logger;

public class ByReferenceMetadataFilter
extends AbstractMetadataFilter {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ByReferenceMetadataFilter.class);
    @Nonnull
    private Map<String, MetadataFilter> filterMap = CollectionSupport.emptyMap();

    public void setFilterMappings(@Nonnull Map<Object, MetadataFilter> map) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(map, (String)"Filter mappings cannot be null");
        this.filterMap = new HashMap<String, MetadataFilter>(map.size());
        for (Map.Entry<Object, MetadataFilter> entry : map.entrySet()) {
            if (entry.getKey() instanceof String) {
                String trimmed = StringSupport.trimOrNull((String)((String)entry.getKey()));
                if (trimmed == null || entry.getValue() == null) continue;
                this.filterMap.put(trimmed, entry.getValue());
                continue;
            }
            if (!(entry.getKey() instanceof Collection)) continue;
            for (Object k : (Collection)entry.getKey()) {
                String trimmed;
                if (!(k instanceof String) || entry.getValue() == null || (trimmed = StringSupport.trimOrNull((String)((String)k))) == null) continue;
                this.filterMap.put(trimmed, entry.getValue());
            }
        }
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        this.checkComponentActive();
        MetadataSource source = (MetadataSource)context.get(MetadataSource.class);
        if (source == null || source.getSourceId() == null) {
            this.log.debug("No metadata source ID found in MetadataFilterContext");
            return metadata;
        }
        MetadataFilter filter = this.filterMap.get(source.getSourceId());
        if (filter == null) {
            this.log.debug("No filters defined for resolver '{}', by-reference filter inactive", (Object)source.getSourceId());
            return metadata;
        }
        this.log.debug("Applying by-reference filter to metadata resolver '{}'", (Object)source.getSourceId());
        return filter.filter(metadata, context);
    }
}

