/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.AttributeType;
import org.cryptacular.x509.dn.NameReader;
import org.cryptacular.x509.dn.RDN;
import org.cryptacular.x509.dn.RDNSequence;
import org.cryptacular.x509.dn.StandardAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509SubjectPrincipalResolver
extends AbstractX509PrincipalResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509SubjectPrincipalResolver.class);
    private static final Pattern ATTR_PATTERN = Pattern.compile("\\$(\\w+)");
    private String principalDescriptor;

    public X509SubjectPrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    private static String[] getAttributeValues(RDNSequence rdnSequence, AttributeType attribute) {
        ArrayList<String> values = new ArrayList<String>();
        for (RDN rdn : rdnSequence.backward()) {
            for (Attribute attr : rdn.getAttributes()) {
                if (!attr.getType().equals((Object)attribute)) continue;
                values.add(attr.getValue());
            }
        }
        return values.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        LOGGER.debug("Resolving principal for [{}]", (Object)certificate);
        StringBuilder sb = new StringBuilder();
        Matcher m = ATTR_PATTERN.matcher(this.principalDescriptor);
        HashMap<String, AttributeContext> attrMap = new HashMap<String, AttributeContext>();
        RDNSequence rdnSequence = new NameReader(certificate).readSubject();
        while (m.find()) {
            String name = m.group(1);
            if (!attrMap.containsKey(name)) {
                String[] values = X509SubjectPrincipalResolver.getAttributeValues(rdnSequence, StandardAttributeType.fromName((String)name));
                attrMap.put(name, new AttributeContext(values));
            }
            AttributeContext context = (AttributeContext)attrMap.get(name);
            m.appendReplacement(sb, context.nextValue());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Generated
    public void setPrincipalDescriptor(String principalDescriptor) {
        this.principalDescriptor = principalDescriptor;
    }

    @Override
    @Generated
    public String toString() {
        return "X509SubjectPrincipalResolver(super=" + super.toString() + ", principalDescriptor=" + this.principalDescriptor + ")";
    }

    private static final class AttributeContext {
        private final Object[] values;
        private int currentIndex;

        AttributeContext(String[] values) {
            this.values = ArrayUtils.clone((Object[])values);
        }

        String nextValue() {
            if (this.currentIndex == this.values.length) {
                throw new IllegalStateException("No values remaining for attribute");
            }
            String value = this.values[this.currentIndex].toString();
            ++this.currentIndex;
            return value;
        }
    }
}

