/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionHolderTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class TypeExtensionWizardBuilder
extends BaseAjaxWizardBuilder<TypeExtensionTO> {
    private static final long serialVersionUID = -7185214439144835423L;
    protected final TypeExtensionHolderTO typeExtensionHolder;
    protected final String anyTypeLabel;
    protected final String auxClassesLabel;
    protected final AnyTypeRestClient anyTypeRestClient;
    protected final AnyTypeClassRestClient anyTypeClassRestClient;

    public TypeExtensionWizardBuilder(TypeExtensionHolderTO typeExtensionHolder, TypeExtensionTO defaultItem, String anyTypeLabel, String auxClassesLabel, AnyTypeRestClient anyTypeRestClient, AnyTypeClassRestClient anyTypeClassRestClient, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.typeExtensionHolder = typeExtensionHolder;
        this.anyTypeLabel = anyTypeLabel;
        this.auxClassesLabel = auxClassesLabel;
        this.anyTypeRestClient = anyTypeRestClient;
        this.anyTypeClassRestClient = anyTypeClassRestClient;
    }

    protected WizardModel buildModelSteps(TypeExtensionTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        return wizardModel;
    }

    protected Serializable onApplyInternal(TypeExtensionTO modelObject) {
        List typeExtensions = this.typeExtensionHolder.getTypeExtensions().stream().filter(typeExt -> !typeExt.getAnyType().equals(modelObject.getAnyType())).collect(Collectors.toList());
        typeExtensions.add(modelObject);
        this.typeExtensionHolder.getTypeExtensions().clear();
        this.typeExtensionHolder.getTypeExtensions().addAll(typeExtensions);
        return this.typeExtensionHolder;
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = 6472869166547883903L;

        public Details(TypeExtensionTO typeExtensionTO) {
            this.setOutputMarkupId(true);
            this.add(new Component[]{new Label("anyType.label", (Serializable)((Object)TypeExtensionWizardBuilder.this.anyTypeLabel))});
            if (typeExtensionTO.getAnyType() == null) {
                List<String> anyTypes = TypeExtensionWizardBuilder.this.anyTypeRestClient.list();
                if (TypeExtensionWizardBuilder.this.typeExtensionHolder instanceof GroupTO) {
                    anyTypes.remove(AnyTypeKind.GROUP.name());
                }
                anyTypes.removeAll(anyTypes.stream().filter(anyType -> this$0.typeExtensionHolder.getTypeExtension(anyType).isPresent()).toList());
                AjaxDropDownChoicePanel anyTypeComponent = new AjaxDropDownChoicePanel("anyType.component", "anyType", (IModel)new PropertyModel((Object)typeExtensionTO, "anyType"));
                anyTypeComponent.setChoices(anyTypes);
                anyTypeComponent.addRequiredLabel();
                this.add(new Component[]{anyTypeComponent.hideLabel().setOutputMarkupId(true)});
            } else {
                AjaxTextFieldPanel anyTypeComponent = new AjaxTextFieldPanel("anyType.component", "anyType", (IModel)new PropertyModel((Object)typeExtensionTO, "anyType"));
                anyTypeComponent.setEnabled(false);
                this.add(new Component[]{anyTypeComponent.hideLabel()});
            }
            this.add(new Component[]{new Label("auxClasses.label", (Serializable)((Object)TypeExtensionWizardBuilder.this.auxClassesLabel))});
            List anyTypeClasses = TypeExtensionWizardBuilder.this.anyTypeClassRestClient.list().stream().map(AnyTypeClassTO::getKey).collect(Collectors.toList());
            AjaxPalettePanel auxClassesPalette = new AjaxPalettePanel.Builder().build("auxClasses.palette", (IModel)new PropertyModel((Object)typeExtensionTO, "auxClasses"), (IModel)new ListModel(anyTypeClasses));
            this.add(new Component[]{auxClassesPalette.hideLabel().setOutputMarkupId(true)});
        }
    }
}

