/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.panels.ConfParam;
import org.apache.syncope.client.console.panels.ParametersWizardPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class ParametersWizardAttrStep
extends WizardStep {
    private static final long serialVersionUID = -7843275202297616553L;
    private final AjaxTextFieldPanel schema;

    public ParametersWizardAttrStep(AjaxWizard.Mode mode, final ParametersWizardPanel.ParametersForm modelObject) {
        this.setOutputMarkupId(true);
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.add(new Component[]{content});
        this.schema = new AjaxTextFieldPanel("schema", this.getString("schema"), (IModel)new PropertyModel((Object)modelObject.getParam(), "schema"));
        this.schema.setRequired(true);
        this.schema.setReadOnly(mode != AjaxWizard.Mode.CREATE);
        content.add(new Component[]{this.schema});
        LoadableDetachableModel<List<PlainSchemaTO>> schemas = new LoadableDetachableModel<List<PlainSchemaTO>>(this){
            private static final long serialVersionUID = 7172461137064525667L;
            final /* synthetic */ ParametersWizardAttrStep this$0;
            {
                this.this$0 = this$0;
            }

            protected List<PlainSchemaTO> load() {
                return List.of(modelObject.getSchema());
            }
        };
        ListView<PlainSchemaTO> attrs = new ListView<PlainSchemaTO>(this, "attrs", (IModel)schemas){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ ParametersWizardAttrStep this$0;
            {
                this.this$0 = this$0;
                super(id, model);
            }

            protected void populateItem(ListItem<PlainSchemaTO> item) {
                item.add(new Component[]{this.this$0.getFieldPanel("panel", modelObject.getParam(), (PlainSchemaTO)item.getModelObject())});
            }
        };
        content.add(new Component[]{attrs});
    }

    private Panel getFieldPanel(String id, ConfParam param, PlainSchemaTO plainSchemaTO) {
        AjaxDateTimeFieldPanel panel;
        String valueHeaderName = this.getString("values");
        switch (plainSchemaTO.getType()) {
            case Date: {
                panel = new AjaxDateTimeFieldPanel(id, valueHeaderName, (IModel)new Model(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT);
                break;
            }
            case Boolean: {
                panel = new AjaxDropDownChoicePanel(id, valueHeaderName, (IModel)new Model(), false);
                ((AjaxDropDownChoicePanel)panel).setChoices(List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
                if (!param.getValues().isEmpty()) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<Boolean>(){
                        private static final long serialVersionUID = -8223314361351275865L;

                        public Object getDisplayValue(Boolean object) {
                            return BooleanUtils.toStringTrueFalse((Boolean)object);
                        }

                        public String getIdValue(Boolean object, int index) {
                            return BooleanUtils.toStringTrueFalse((Boolean)object);
                        }

                        public Boolean getObject(String id, IModel<? extends List<? extends Boolean>> choices) {
                            return BooleanUtils.toBoolean((String)id);
                        }
                    });
                }
                ((AjaxDropDownChoicePanel)panel).setNullValid(false);
                break;
            }
            case Long: {
                panel = new AjaxNumberFieldPanel.Builder().convertValuesToString(false).build(id, valueHeaderName, Long.class, (IModel)new Model());
                break;
            }
            case Double: {
                panel = new AjaxNumberFieldPanel.Builder().convertValuesToString(false).build(id, valueHeaderName, Double.class, (IModel)new Model());
                break;
            }
            case Binary: {
                panel = new BinaryFieldPanel(id, valueHeaderName, (IModel)new Model(), plainSchemaTO.getMimeType(), (String)((Object)this.schema.getModelObject()));
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel(id, valueHeaderName, (IModel)new Model(), false);
            }
        }
        if (plainSchemaTO.isMultivalue()) {
            return new MultiFieldPanel.Builder((IModel)new PropertyModel((Object)param, "values")).build(id, valueHeaderName, (FieldPanel)panel);
        }
        panel.setNewModel(param.getValues());
        return panel;
    }
}

