/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class MembersTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -3195479265440591519L;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    protected GroupTO groupTO;
    protected final Form<?> form;
    protected final Model<String> typeModel = new Model();
    private final LoadableDetachableModel<List<String>> anyTypes = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return MembersTogglePanel.this.anyTypeRestClient.list().stream().filter(anyType -> !AnyTypeKind.GROUP.name().equals(anyType)).collect(Collectors.toList());
        }
    };

    public MembersTogglePanel(final PageReference pageRef) {
        super("outer", "groupMembers", pageRef);
        this.form = new Form("membersForm");
        this.addInnerObject(new Component[]{this.form});
        FieldPanel type = new AjaxDropDownChoicePanel("type", "type", this.typeModel, false).setChoices(this.anyTypes).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
            private static final long serialVersionUID = -200150326532439794L;

            public Object getDisplayValue(String anyType) {
                return new ResourceModel("anyType." + anyType, anyType).getObject();
            }
        }).setStyleSheet(new String[]{"form-control"}).setRequired(true);
        type.hideLabel();
        this.form.add(new Component[]{type});
        this.form.add(new Component[]{new AjaxSubmitLink(this, "changeit", this.form){
            private static final long serialVersionUID = -7978723352517770644L;
            final /* synthetic */ MembersTogglePanel this$0;
            {
                this.this$0 = this$0;
                super(id, form);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    this.this$0.onApplyInternal(this.this$0.groupTO, (String)((Object)this.this$0.typeModel.getObject()), target);
                    this.this$0.toggle(target, false);
                }
                catch (SyncopeClientException e) {
                    TogglePanel.LOG.error("While inspecting group memebers of type {}", (Object)this.this$0.typeModel.getObject(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }

    protected abstract Serializable onApplyInternal(GroupTO var1, String var2, AjaxRequestTarget var3);

    public void setTargetObject(GroupTO groupTO) {
        this.groupTO = groupTO;
    }
}

