/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.databind.JsonNode;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.DomainAdminCredentialsPanel;
import org.apache.syncope.client.console.panels.DomainPoolModalPanel;
import org.apache.syncope.client.console.panels.DomainWizardBuilder;
import org.apache.syncope.client.console.rest.SyncopeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.common.keymaster.client.api.model.Neo4jDomain;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class DomainDirectoryPanel
extends DirectoryPanel<Domain, Domain, DomainProvider, SyncopeRestClient> {
    private static final long serialVersionUID = -1039907608594680220L;
    @SpringBean
    private DomainOps domainOps;
    private final BaseModal<Domain> utilityModal = new BaseModal("outer");
    private Class<? extends Domain> domainClass = JPADomain.class;

    public DomainDirectoryPanel(String id, PageReference pageRef) {
        super(id, null, pageRef);
        JPADomain newDomain;
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            if (this.actionTogglePanel.isVisibleInHierarchy()) {
                this.actionTogglePanel.toggle(target, false);
            }
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal, true);
        this.utilityModal.size(Modal.Size.Small);
        this.utilityModal.addSubmitButton();
        try {
            JsonNode info = SyncopeConsoleSession.get().getAnonymousClient().info();
            this.domainClass = info.has("persistence") && info.get("persistence").has("vendor") && "OpenJPA".equals(info.get("persistence").get("vendor").asText()) ? JPADomain.class : Neo4jDomain.class;
            newDomain = this.domainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Could not instantiate {}", (Object)this.domainClass.getName(), (Object)e);
            newDomain = new JPADomain();
        }
        this.addNewItemPanelBuilder(new DomainWizardBuilder(this.domainOps, (Domain)newDomain, pageRef), true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"KEYMASTER");
    }

    @Override
    protected List<IColumn<Domain, String>> getColumns() {
        ArrayList<IColumn<Domain, String>> columns = new ArrayList<IColumn<Domain, String>>();
        columns.add((IColumn<Domain, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        if (JPADomain.class.equals(this.domainClass)) {
            columns.add((IColumn<Domain, String>)new PropertyColumn((IModel)new StringResourceModel("jdbcURL", (Component)this), (Object)"jdbcURL", "jdbcURL"));
            columns.add((IColumn<Domain, String>)new PropertyColumn((IModel)new StringResourceModel("poolMaxActive", (Component)this), (Object)"poolMaxActive", "poolMaxActive"));
            columns.add((IColumn<Domain, String>)new PropertyColumn((IModel)new StringResourceModel("poolMinIdle", (Component)this), (Object)"poolMinIdle", "poolMinIdle"));
        } else {
            columns.add((IColumn<Domain, String>)new PropertyColumn((IModel)new StringResourceModel("uri", (Component)this), (Object)"uri", "uri"));
            columns.add((IColumn<Domain, String>)new PropertyColumn((IModel)new StringResourceModel("poolMaxActive", (Component)this), (Object)"maxConnectionPoolSize", "maxConnectionPoolSize"));
        }
        return columns;
    }

    @Override
    protected ActionsPanel<Domain> getActions(final IModel<Domain> model) {
        ActionsPanel<Domain> panel = super.getActions(model);
        panel.add(new ActionLink<Domain>(this){
            private static final long serialVersionUID = 7610801302168867641L;
            final /* synthetic */ DomainDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, Domain ignore) {
                this.this$0.utilityModal.header((IModel)new ResourceModel("adjust.pool.size"));
                this.this$0.utilityModal.setContent((ModalPanel)new DomainPoolModalPanel((Domain)model.getObject(), this.this$0.utilityModal, this.this$0.pageRef));
                this.this$0.utilityModal.show(true);
                target.add(new Component[]{this.this$0.utilityModal});
            }
        }, ActionLink.ActionType.EDIT, "KEYMASTER");
        panel.add(new ActionLink<Domain>(this){
            private static final long serialVersionUID = 7610801302168867641L;
            final /* synthetic */ DomainDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, Domain ignore) {
                this.this$0.utilityModal.header((IModel)new ResourceModel("set.admin.credentials"));
                this.this$0.utilityModal.setContent((ModalPanel)new DomainAdminCredentialsPanel((Domain)model.getObject(), this.this$0.utilityModal, this.this$0.pageRef));
                this.this$0.utilityModal.show(true);
                target.add(new Component[]{this.this$0.utilityModal});
            }
        }, ActionLink.ActionType.PASSWORD_MANAGEMENT, "KEYMASTER");
        panel.add(new ActionLink<Domain>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ DomainDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, Domain ignore) {
                Domain domain = (Domain)model.getObject();
                try {
                    this.this$0.domainOps.delete(domain.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (KeymasterException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)domain.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "KEYMASTER", true);
        return panel;
    }

    @Override
    protected DomainProvider dataProvider() {
        return new DomainProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "domain.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected final class DomainProvider
    extends DirectoryDataProvider<Domain> {
        private static final long serialVersionUID = 8668261951640646188L;
        private final SortableDataProviderComparator<Domain> comparator;

        public DomainProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<Domain>(this);
        }

        public Iterator<? extends Domain> iterator(long first, long count) {
            List list = DomainDirectoryPanel.this.domainOps.list();
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return DomainDirectoryPanel.this.domainOps.list().size();
        }

        public IModel<Domain> model(final Domain object) {
            return new IModel<Domain>(this){
                private static final long serialVersionUID = 8093553921710742624L;
                final /* synthetic */ DomainProvider this$1;
                {
                    this.this$1 = this$1;
                }

                public Domain getObject() {
                    return object;
                }
            };
        }
    }
}

