/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import com.netflix.spectator.api.Tag;
import com.netflix.spectator.ipc.IpcResult;
import com.netflix.spectator.ipc.IpcTagKey;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;

public enum IpcStatus implements Tag
{
    success,
    bad_request,
    unexpected_error,
    connection_error,
    unavailable,
    throttled,
    timeout,
    cancelled,
    access_denied,
    application_error;


    public String key() {
        return IpcTagKey.status.key();
    }

    public String value() {
        return this.name();
    }

    public IpcResult result() {
        return this == success ? IpcResult.success : IpcResult.failure;
    }

    public static IpcStatus forHttpStatus(int httpStatus) {
        return IpcStatus.forHttpStatusStandard(httpStatus == 503 ? 429 : httpStatus);
    }

    public static IpcStatus forHttpStatusStandard(int httpStatus) {
        IpcStatus status;
        switch (httpStatus) {
            case 200: {
                status = success;
                break;
            }
            case 401: {
                status = access_denied;
                break;
            }
            case 402: {
                status = access_denied;
                break;
            }
            case 403: {
                status = access_denied;
                break;
            }
            case 404: {
                status = success;
                break;
            }
            case 405: {
                status = bad_request;
                break;
            }
            case 406: {
                status = bad_request;
                break;
            }
            case 407: {
                status = access_denied;
                break;
            }
            case 408: {
                status = timeout;
                break;
            }
            case 429: {
                status = throttled;
                break;
            }
            case 503: {
                status = unavailable;
                break;
            }
            case 511: {
                status = access_denied;
                break;
            }
            default: {
                status = httpStatus < 100 ? unexpected_error : (httpStatus < 400 ? success : (httpStatus < 500 ? bad_request : unexpected_error));
            }
        }
        return status;
    }

    public static IpcStatus forException(Throwable t) {
        IpcStatus status = t instanceof SSLException ? access_denied : (t instanceof SocketTimeoutException || t instanceof TimeoutException ? timeout : (t instanceof IOException ? connection_error : (t instanceof IllegalArgumentException || t instanceof IllegalStateException ? bad_request : unexpected_error)));
        return status;
    }
}

