/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceUnitInfo;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.syncope.core.persistence.jpa.openjpa.ConnectorManagerRemoteCommitListener;
import org.apache.syncope.core.persistence.jpa.spring.CommonEntityManagerFactoryConf;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class DomainEntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    private static final long serialVersionUID = 49152547930966545L;
    protected ConnectorManagerRemoteCommitListener connectorManagerRemoteCommitListener;

    public void setCommonEntityManagerFactoryConf(CommonEntityManagerFactoryConf commonEMFConf) {
        super.setJpaPropertyMap(commonEMFConf.getJpaPropertyMap());
        if (commonEMFConf.getPackagesToScan() != null) {
            super.setPackagesToScan(commonEMFConf.getPackagesToScan());
        }
        super.setValidationMode(commonEMFConf.getValidationMode());
        if (commonEMFConf.getPersistenceUnitPostProcessors() != null) {
            super.setPersistenceUnitPostProcessors(commonEMFConf.getPersistenceUnitPostProcessors());
        }
    }

    public void setConnectorManagerRemoteCommitListener(ConnectorManagerRemoteCommitListener connectorManagerRemoteCommitListener) {
        this.connectorManagerRemoteCommitListener = connectorManagerRemoteCommitListener;
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
        super.postProcessEntityManagerFactory(emf, pui);
        OpenJPAEntityManagerFactorySPI emfspi = (OpenJPAEntityManagerFactorySPI)emf.unwrap(OpenJPAEntityManagerFactorySPI.class);
        emfspi.getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)this.connectorManagerRemoteCommitListener);
    }
}

