/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.group;

import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.group.GRelationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.GroupTypeExtension;
import org.apache.syncope.core.persistence.common.validation.GroupCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAny;
import org.apache.syncope.core.persistence.jpa.entity.AbstractRelatable;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTypeClass;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGRelationship;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroupTypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.group.JSONGroupListener;

@Entity
@Table(name="SyncopeGroup")
@EntityListeners(value={JSONGroupListener.class})
@Cacheable
@GroupCheck
public class JPAGroup
extends AbstractRelatable<Group, GRelationship>
implements Group {
    private static final long serialVersionUID = -5281258853142421875L;
    public static final String TABLE = "SyncopeGroup";
    @Column(unique=true)
    @NotNull
    private String name;
    private String plainAttrs;
    @Transient
    private final List<PlainAttr> plainAttrsList = new ArrayList<PlainAttr>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "resource_id"})})
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="group_id")}, inverseJoinColumns={@JoinColumn(name="anyTypeClass_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"group_id", "anyTypeClass_id"})})
    private List<JPAAnyTypeClass> auxClasses = new ArrayList<JPAAnyTypeClass>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="group")
    private List<JPAGroupTypeExtension> typeExtensions = new ArrayList<JPAGroupTypeExtension>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="leftEnd")
    @Valid
    private List<JPAGRelationship> relationships = new ArrayList<JPAGRelationship>();
    private static int pcInheritedFieldCount = AbstractRelatable.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getName() {
        return JPAGroup.pcGetname(this);
    }

    public void setName(String name) {
        JPAGroup.pcSetname(this, name);
    }

    public AnyType getType() {
        return ((AnyTypeDAO)ApplicationContextProvider.getBeanFactory().getBean(AnyTypeDAO.class)).getGroup();
    }

    public void setType(AnyType type) {
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAGroup.pcGetresources(this).contains((JPAExternalResource)resource) || JPAGroup.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<? extends ExternalResource> getResources() {
        return JPAGroup.pcGetresources(this);
    }

    @Override
    public List<PlainAttr> getPlainAttrsList() {
        return this.plainAttrsList;
    }

    @Override
    public String getPlainAttrsJSON() {
        return JPAGroup.pcGetplainAttrs(this);
    }

    @Override
    public void setPlainAttrsJSON(String plainAttrs) {
        JPAGroup.pcSetplainAttrs(this, plainAttrs);
    }

    public boolean add(PlainAttr attr) {
        return this.plainAttrsList.add(attr);
    }

    public boolean remove(PlainAttr attr) {
        return this.plainAttrsList.removeIf(a -> a.getSchema().equals(attr.getSchema()) && Objects.equals(a.getRelationship(), attr.getRelationship()));
    }

    public Optional<PlainAttr> getPlainAttr(String plainSchema) {
        return this.plainAttrsList.stream().filter(attr -> attr.getRelationship() == null && plainSchema.equals(attr.getSchema())).findFirst();
    }

    public List<PlainAttr> getPlainAttrs() {
        return this.plainAttrsList.stream().filter(attr -> attr.getRelationship() == null).toList();
    }

    public boolean add(AnyTypeClass auxClass) {
        this.checkType(auxClass, JPAAnyTypeClass.class);
        return JPAGroup.pcGetauxClasses(this).contains((JPAAnyTypeClass)auxClass) || JPAGroup.pcGetauxClasses(this).add((JPAAnyTypeClass)auxClass);
    }

    public List<? extends AnyTypeClass> getAuxClasses() {
        return JPAGroup.pcGetauxClasses(this);
    }

    public boolean add(GroupTypeExtension typeExtension) {
        this.checkType(typeExtension, JPAGroupTypeExtension.class);
        return JPAGroup.pcGettypeExtensions(this).add((JPAGroupTypeExtension)typeExtension);
    }

    public Optional<? extends GroupTypeExtension> getTypeExtension(AnyType anyType) {
        return JPAGroup.pcGettypeExtensions(this).stream().filter(typeExtension -> typeExtension.getAnyType().equals((Object)anyType)).findFirst();
    }

    public List<? extends GroupTypeExtension> getTypeExtensions() {
        return JPAGroup.pcGettypeExtensions(this);
    }

    public boolean add(GRelationship relationship) {
        this.checkType(relationship, JPAGRelationship.class);
        return JPAGroup.pcGetrelationships(this).add((JPAGRelationship)relationship);
    }

    public boolean remove(Relationship<?, ?> relationship) {
        this.checkType(relationship, JPAGRelationship.class);
        this.plainAttrsList.removeIf(attr -> Objects.equals(attr.getRelationship(), relationship.getKey()));
        return JPAGroup.pcGetrelationships(this).remove((JPAGRelationship)relationship);
    }

    public List<? extends GRelationship> getRelationships() {
        return JPAGroup.pcGetrelationships(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractAny.class;
        pcFieldNames = new String[]{"auxClasses", "name", "plainAttrs", "relationships", "resources", "typeExtensions"};
        pcFieldTypes = new Class[]{List.class, String.class, String.class, List.class, List.class, List.class};
        pcFieldFlags = new byte[]{5, 26, 26, 5, 5, 10};
        PCRegistry.register(JPAGroup.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAGroup", (PersistenceCapable)new JPAGroup());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.auxClasses = null;
        this.name = null;
        this.plainAttrs = null;
        this.relationships = null;
        this.resources = null;
        this.typeExtensions = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAGroup jPAGroup = new JPAGroup();
        if (bl) {
            jPAGroup.pcClearFields();
        }
        jPAGroup.pcStateManager = stateManager;
        jPAGroup.pcCopyKeyFieldsFromObjectId(object);
        return jPAGroup;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAGroup jPAGroup = new JPAGroup();
        if (bl) {
            jPAGroup.pcClearFields();
        }
        jPAGroup.pcStateManager = stateManager;
        return jPAGroup;
    }

    protected static int pcGetManagedFieldCount() {
        return 6 + AbstractAny.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.plainAttrs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.relationships = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.typeExtensions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.auxClasses);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.plainAttrs);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.relationships);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.typeExtensions);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAGroup jPAGroup, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAGroup, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.auxClasses = jPAGroup.auxClasses;
                return;
            }
            case 1: {
                this.name = jPAGroup.name;
                return;
            }
            case 2: {
                this.plainAttrs = jPAGroup.plainAttrs;
                return;
            }
            case 3: {
                this.relationships = jPAGroup.relationships;
                return;
            }
            case 4: {
                this.resources = jPAGroup.resources;
                return;
            }
            case 5: {
                this.typeExtensions = jPAGroup.typeExtensions;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAGroup jPAGroup = (JPAGroup)object;
        if (jPAGroup.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAGroup, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAGroup.class;
    }

    private static final List pcGetauxClasses(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.auxClasses;
        }
        int n = pcInheritedFieldCount + 0;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.auxClasses;
    }

    private static final void pcSetauxClasses(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.auxClasses = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 0, jPAGroup.auxClasses, (Object)list, 0);
    }

    private static final String pcGetname(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.name;
        }
        int n = pcInheritedFieldCount + 1;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.name;
    }

    private static final void pcSetname(JPAGroup jPAGroup, String string) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.name = string;
            return;
        }
        jPAGroup.pcStateManager.settingStringField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 1, jPAGroup.name, string, 0);
    }

    private static final String pcGetplainAttrs(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.plainAttrs;
        }
        int n = pcInheritedFieldCount + 2;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.plainAttrs;
    }

    private static final void pcSetplainAttrs(JPAGroup jPAGroup, String string) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.plainAttrs = string;
            return;
        }
        jPAGroup.pcStateManager.settingStringField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 2, jPAGroup.plainAttrs, string, 0);
    }

    private static final List pcGetrelationships(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.relationships;
        }
        int n = pcInheritedFieldCount + 3;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.relationships;
    }

    private static final void pcSetrelationships(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.relationships = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 3, jPAGroup.relationships, (Object)list, 0);
    }

    private static final List pcGetresources(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.resources;
        }
        int n = pcInheritedFieldCount + 4;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.resources;
    }

    private static final void pcSetresources(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.resources = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 4, jPAGroup.resources, (Object)list, 0);
    }

    private static final List pcGettypeExtensions(JPAGroup jPAGroup) {
        if (jPAGroup.pcStateManager == null) {
            return jPAGroup.typeExtensions;
        }
        int n = pcInheritedFieldCount + 5;
        jPAGroup.pcStateManager.accessingField(n);
        return jPAGroup.typeExtensions;
    }

    private static final void pcSettypeExtensions(JPAGroup jPAGroup, List list) {
        if (jPAGroup.pcStateManager == null) {
            jPAGroup.typeExtensions = list;
            return;
        }
        jPAGroup.pcStateManager.settingObjectField((PersistenceCapable)jPAGroup, pcInheritedFieldCount + 5, jPAGroup.typeExtensions, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

