/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.jpa.dao.repo.GroupRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

public interface GroupRepo
extends PagingAndSortingRepository<JPAGroup, String>,
GroupRepoExt,
GroupDAO {
    @Query(value="SELECT e.id FROM #{#entityName} e WHERE e.name = :name")
    public Optional<String> findKey(@Param(value="name") String var1);

    @Query(value="SELECT e.id FROM #{#entityName} e WHERE LOWER(e.name) LIKE :pattern")
    public List<String> findKeysByNamePattern(@Param(value="pattern") String var1);

    @Query(value="SELECT e FROM #{#entityName} e WHERE e.id IN (:keys)")
    public List<Group> findByKeys(@Param(value="keys") List<String> var1);

    @Query(value="SELECT DISTINCT e.leftEnd.id FROM JPAAMembership e WHERE e.rightEnd.id = :groupKey")
    public List<String> findAMembers(@Param(value="groupKey") String var1);

    @Query(value="SELECT DISTINCT e.leftEnd.id FROM JPAUMembership e WHERE e.rightEnd.id = :groupKey")
    public List<String> findUMembers(@Param(value="groupKey") String var1);

    @Query(value="SELECT COUNT(DISTINCT e.leftEnd.id) FROM JPAAMembership e WHERE e.rightEnd.id = :groupKey")
    public long countAMembers(@Param(value="groupKey") String var1);

    @Query(value="SELECT COUNT(DISTINCT e.leftEnd.id) FROM JPAUMembership e WHERE e.rightEnd.id = :groupKey")
    public long countUMembers(@Param(value="groupKey") String var1);
}

