/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Table;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.sql.DataSource;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.helpers.IOUtils;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.utils.FormatUtils;
import org.apache.syncope.core.persistence.common.content.AbstractXMLContentExporter;
import org.apache.syncope.core.persistence.common.content.MultiParentNode;
import org.apache.syncope.core.persistence.common.content.MultiParentNodeOp;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLContentExporter
extends AbstractXMLContentExporter {
    protected static final Set<String> TABLE_PREFIXES_TO_BE_EXCLUDED = Set.of("JobStatus", "AuditEvent");
    protected static BiFunction<Map<String, EntityType<?>>, Type<?>, String> GET_KEY = (entities, type) -> entities.entrySet().stream().filter(entry -> type.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElse(null);
    protected final DomainHolder<DataSource> domainHolder;
    protected final RealmSearchDAO realmSearchDAO;
    protected final EntityManagerFactory entityManagerFactory;
    protected final ConfigurableApplicationContext ctx;

    protected static boolean isTableAllowed(String tableName) {
        return TABLE_PREFIXES_TO_BE_EXCLUDED.stream().noneMatch(prefix -> tableName.toUpperCase().startsWith(prefix.toUpperCase()));
    }

    protected static String getValues(ResultSet rs, String columnName, Integer columnType) throws SQLException {
        String value = null;
        try {
            switch (columnType) {
                case -4: 
                case -3: 
                case -2: {
                    InputStream is = rs.getBinaryStream(columnName);
                    if (is != null) {
                        value = DatatypeConverter.printHexBinary((byte[])IOUtils.toString((InputStream)is).getBytes());
                    }
                    break;
                }
                case 2004: {
                    Blob blob = rs.getBlob(columnName);
                    if (blob != null) {
                        value = DatatypeConverter.printHexBinary((byte[])IOUtils.toString((InputStream)blob.getBinaryStream()).getBytes());
                    }
                    break;
                }
                case -7: 
                case 16: {
                    value = rs.getBoolean(columnName) ? "1" : "0";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    Timestamp timestamp = rs.getTimestamp(columnName);
                    if (timestamp != null) {
                        value = FormatUtils.format((TemporalAccessor)OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp.getTime()), ZoneId.systemDefault()));
                    }
                    break;
                }
                default: {
                    value = rs.getString(columnName);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error fetching value from {}", (Object)columnName, (Object)e);
        }
        return value;
    }

    protected static String columnName(Supplier<Stream<Attribute<?, ?>>> attrs, String columnName) {
        Object name = attrs.get().map(attr -> {
            if (attr.getName().equalsIgnoreCase(columnName)) {
                return attr.getName();
            }
            Field field = (Field)attr.getJavaMember();
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.name().equalsIgnoreCase(columnName)) {
                return column.name();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(columnName);
        if (Strings.CI.endsWith((CharSequence)name, (CharSequence)"_ID")) {
            String left = StringUtils.substringBeforeLast((String)name, (String)"_");
            String prefix = attrs.get().filter(attr -> left.equalsIgnoreCase(attr.getName())).findFirst().map(Attribute::getName).orElse(left);
            name = prefix + "_id";
        }
        return name;
    }

    protected static Map<String, Pair<String, String>> relationTables(Map<String, EntityType<?>> entities) {
        HashMap<String, Pair<String, String>> relationTables = new HashMap<String, Pair<String, String>>();
        entities.values().forEach(e -> e.getAttributes().stream().filter(a -> a.getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC).forEach(a -> {
            Field field = (Field)a.getJavaMember();
            String attrName = Optional.ofNullable(field.getAnnotation(Column.class)).map(Column::name).orElseGet(() -> ((Attribute)a).getName());
            Optional.ofNullable(field.getAnnotation(CollectionTable.class)).ifPresent(collectionTable -> relationTables.put(collectionTable.name(), Pair.of((Object)attrName, (Object)collectionTable.joinColumns()[0].name())));
            Optional.ofNullable(field.getAnnotation(JoinTable.class)).ifPresent(joinTable -> {
                Object tableName = joinTable.name();
                if (StringUtils.isBlank((CharSequence)tableName)) {
                    tableName = GET_KEY.apply(entities, (Type<?>)e) + "_" + GET_KEY.apply(entities, ((PluralAttribute)a).getElementType());
                }
                relationTables.put((String)tableName, (Pair<String, String>)Pair.of((Object)joinTable.joinColumns()[0].name(), (Object)joinTable.inverseJoinColumns()[0].name()));
            });
        }));
        return relationTables;
    }

    protected static List<String> sortByForeignKeys(Connection conn, String schema, Set<String> tableNames) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        HashSet roots = new HashSet();
        TreeMap exploited = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (String tableName : tableNames) {
            MultiParentNode node = Optional.ofNullable((MultiParentNode)exploited.get(tableName)).orElseGet(() -> {
                MultiParentNode n = new MultiParentNode(tableName);
                roots.add(n);
                exploited.put(tableName, n);
                return n;
            });
            HashSet<String> pkTableNames = new HashSet<String>();
            try (ResultSet rs = meta.getImportedKeys(conn.getCatalog(), schema, tableName);){
                while (rs.next()) {
                    pkTableNames.add(rs.getString("PKTABLE_NAME"));
                }
            }
            pkTableNames.stream().filter(pkTableName -> !tableName.equalsIgnoreCase((String)pkTableName)).forEach(pkTableName -> {
                MultiParentNode pkNode = Optional.ofNullable((MultiParentNode)exploited.get(pkTableName)).orElseGet(() -> {
                    MultiParentNode n = new MultiParentNode(pkTableName);
                    roots.add(n);
                    exploited.put(pkTableName, n);
                    return n;
                });
                pkNode.addChild(node);
                roots.remove(node);
            });
        }
        ArrayList<String> sortedTableNames = new ArrayList<String>(tableNames.size());
        MultiParentNodeOp.traverseTree(roots, sortedTableNames);
        sortedTableNames.retainAll(tableNames);
        LOG.debug("Tables after retainAll {}", sortedTableNames);
        Collections.reverse(sortedTableNames);
        return sortedTableNames;
    }

    public XMLContentExporter(DomainHolder<DataSource> domainHolder, RealmSearchDAO realmSearchDAO, EntityManagerFactory entityManagerFactory, ConfigurableApplicationContext ctx) {
        this.domainHolder = domainHolder;
        this.realmSearchDAO = realmSearchDAO;
        this.entityManagerFactory = entityManagerFactory;
        this.ctx = ctx;
    }

    protected void exportTable(DataSource dataSource, String tableName, int threshold, Map<String, EntityType<?>> entities, Map<String, Pair<String, String>> relationTables, TransformerHandler handler) throws MetaDataAccessException, SAXException {
        LOG.debug("Export table {}", (Object)tableName);
        String orderBy = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, meta -> {
            StringJoiner ob = new StringJoiner(",");
            try (ResultSet pkeyRS = meta.getPrimaryKeys(null, null, tableName);){
                while (pkeyRS.next()) {
                    Optional.ofNullable(pkeyRS.getString("COLUMN_NAME")).ifPresent(ob::add);
                }
            }
            return ob.toString();
        });
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM ").append(tableName).append(" a");
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            query.append(" ORDER BY ").append(orderBy);
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.setMaxRows(threshold);
        Optional<EntityType> entity = entities.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(tableName)).findFirst().map(Map.Entry::getValue);
        String outputTableName = entity.map(e -> GET_KEY.apply(entities, (Type<?>)e)).orElseGet(() -> relationTables.keySet().stream().filter(tableName::equalsIgnoreCase).findFirst().orElse(tableName));
        ArrayList rows = new ArrayList();
        jdbcTemplate.query(query.toString(), rs -> {
            HashMap row = new HashMap();
            rows.add(row);
            ResultSetMetaData rsMeta = rs.getMetaData();
            for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                String columnName = rsMeta.getColumnName(i + 1);
                Integer columnType = rsMeta.getColumnType(i + 1);
                Optional.ofNullable(XMLContentExporter.getValues(rs, columnName, columnType)).ifPresent(value -> {
                    String name = entity.map(e -> XMLContentExporter.columnName(() -> e.getAttributes().stream(), columnName)).orElse(columnName);
                    if (relationTables.containsKey(outputTableName)) {
                        Pair relationColumns = (Pair)relationTables.get(outputTableName);
                        if (name.equalsIgnoreCase((String)relationColumns.getLeft())) {
                            name = (String)relationColumns.getLeft();
                        } else if (name.equalsIgnoreCase((String)relationColumns.getRight())) {
                            name = (String)relationColumns.getRight();
                        }
                    }
                    row.put(name, value);
                    LOG.debug("Add for table {}: {}=\"{}\"", new Object[]{outputTableName, name, value});
                });
            }
        });
        if (tableName.equalsIgnoreCase("Realm")) {
            ArrayList realmRows = new ArrayList(rows);
            rows.clear();
            this.realmSearchDAO.findDescendants("/", null, Pageable.unpaged()).forEach(realm -> realmRows.stream().filter(row -> {
                String id = Optional.ofNullable((String)row.get("ID")).orElseGet(() -> (String)row.get("id"));
                return realm.getKey().equals(id);
            }).findFirst().ifPresent(rows::add));
        }
        for (Map row : rows) {
            AttributesImpl attrs = new AttributesImpl();
            row.forEach((key, value) -> attrs.addAttribute("", "", (String)key, "CDATA", (String)value));
            handler.startElement("", "", outputTableName, attrs);
            handler.endElement("", "", outputTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String domain, int threshold, OutputStream os, String ... elements) throws SAXException, TransformerConfigurationException {
        Object schemaBean;
        HashMap entities = new HashMap();
        this.entityManagerFactory.getMetamodel().getEntities().forEach(entity -> Optional.ofNullable(entity.getBindableJavaType().getAnnotation(Table.class)).ifPresent(table -> entities.put(table.name(), (EntityType<?>)entity)));
        TransformerHandler handler = this.start(os);
        DataSource dataSource = Optional.ofNullable((DataSource)this.domainHolder.getDomains().get(domain)).orElseThrow(() -> new IllegalArgumentException("Could not find DataSource for domain " + domain));
        String schema = null;
        if (this.ctx.getBeanFactory().containsBean(domain + "DatabaseSchema") && (schemaBean = this.ctx.getBeanFactory().getBean(domain + "DatabaseSchema")) instanceof String) {
            String string;
            schema = string = (String)schemaBean;
        }
        Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
        try {
            TreeSet<String> tableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (ArrayUtils.isEmpty((Object[])elements)) {
                try (ResultSet rs = conn.getMetaData().getTables(null, schema, null, new String[]{"TABLE"});){
                    while (rs.next()) {
                        String tableName = rs.getString("TABLE_NAME");
                        LOG.debug("Found table {}", (Object)tableName);
                        if (!XMLContentExporter.isTableAllowed(tableName)) continue;
                        tableNames.add(tableName);
                    }
                }
                catch (SQLException e) {
                    LOG.error("While getting the list of tables", (Throwable)e);
                }
            } else {
                tableNames.addAll(Stream.of(elements).toList());
            }
            LOG.debug("Tables to be exported {}", tableNames);
            for (String tableName : XMLContentExporter.sortByForeignKeys(conn, schema, tableNames)) {
                try {
                    this.exportTable(dataSource, tableName, threshold, entities, XMLContentExporter.relationTables(entities), handler);
                }
                catch (Exception e) {
                    LOG.error("Failure exporting table {}", (Object)tableName, (Object)e);
                }
            }
        }
        catch (SQLException e) {
            LOG.error("While exporting database content", (Throwable)e);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
        }
        this.end(handler);
    }
}

