/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.request.LinkedAccountUR;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.StringReplacePatchItem;

@Schema(allOf={AnyUR.class})
public class UserUR
extends AnyUR {
    private static final long serialVersionUID = 2872795537911821448L;
    private StringReplacePatchItem username;
    private PasswordPatch password;
    private StringReplacePatchItem securityQuestion;
    private StringReplacePatchItem securityAnswer;
    private BooleanReplacePatchItem mustChangePassword;
    private final Set<MembershipUR> memberships = new HashSet<MembershipUR>();
    private final Set<StringPatchItem> roles = new HashSet<StringPatchItem>();
    private final List<LinkedAccountUR> linkedAccounts = new ArrayList<LinkedAccountUR>();

    @Override
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.request.UserUR")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public StringReplacePatchItem getUsername() {
        return this.username;
    }

    public void setUsername(StringReplacePatchItem username) {
        this.username = username;
    }

    public PasswordPatch getPassword() {
        return this.password;
    }

    public void setPassword(PasswordPatch password) {
        this.password = password;
    }

    public StringReplacePatchItem getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(StringReplacePatchItem securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public StringReplacePatchItem getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(StringReplacePatchItem securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    public BooleanReplacePatchItem getMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(BooleanReplacePatchItem mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    public Set<MembershipUR> getMemberships() {
        return this.memberships;
    }

    public Set<StringPatchItem> getRoles() {
        return this.roles;
    }

    public List<LinkedAccountUR> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @JsonIgnore
    protected boolean isEmptyNotConsideringPassword() {
        return super.isEmpty() && this.username == null && this.securityQuestion == null && this.securityAnswer == null && this.mustChangePassword == null && this.memberships.isEmpty() && this.roles.isEmpty() && this.linkedAccounts.isEmpty();
    }

    @JsonIgnore
    public boolean isEmptyButPassword() {
        return this.isEmptyNotConsideringPassword() && this.password != null;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyNotConsideringPassword() && this.password == null;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.username).append((Object)this.password).append((Object)this.securityQuestion).append((Object)this.securityAnswer).append((Object)this.mustChangePassword).append(this.memberships).append(this.roles).append(this.linkedAccounts).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserUR other = (UserUR)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.username, (Object)other.username).append((Object)this.securityQuestion, (Object)other.securityQuestion).append((Object)this.securityAnswer, (Object)other.securityAnswer).append((Object)this.mustChangePassword, (Object)other.mustChangePassword).append(this.memberships, other.memberships).append(this.roles, other.roles).append(this.linkedAccounts, other.linkedAccounts).build();
    }

    public static class Builder
    extends AnyUR.Builder<UserUR, Builder> {
        public Builder(String key) {
            super(key);
        }

        @Override
        protected UserUR newInstance() {
            return new UserUR();
        }

        public Builder username(StringReplacePatchItem username) {
            ((UserUR)this.getInstance()).setUsername(username);
            return this;
        }

        public Builder password(PasswordPatch password) {
            ((UserUR)this.getInstance()).setPassword(password);
            return this;
        }

        public Builder securityQuestion(StringReplacePatchItem securityQuestion) {
            ((UserUR)this.getInstance()).setSecurityQuestion(securityQuestion);
            return this;
        }

        public Builder securityAnswer(StringReplacePatchItem securityAnswer) {
            ((UserUR)this.getInstance()).setSecurityAnswer(securityAnswer);
            return this;
        }

        public Builder mustChangePassword(BooleanReplacePatchItem mustChangePassword) {
            ((UserUR)this.getInstance()).setMustChangePassword(mustChangePassword);
            return this;
        }

        public Builder membership(MembershipUR membership) {
            ((UserUR)this.getInstance()).getMemberships().add(membership);
            return this;
        }

        public Builder memberships(MembershipUR ... memberships) {
            ((UserUR)this.getInstance()).getMemberships().addAll(List.of(memberships));
            return this;
        }

        public Builder memberships(Collection<MembershipUR> memberships) {
            ((UserUR)this.getInstance()).getMemberships().addAll(memberships);
            return this;
        }

        public Builder role(StringPatchItem role) {
            ((UserUR)this.getInstance()).getRoles().add(role);
            return this;
        }

        public Builder roles(StringPatchItem ... roles) {
            ((UserUR)this.getInstance()).getRoles().addAll(List.of(roles));
            return this;
        }

        public Builder roles(Collection<StringPatchItem> roles) {
            ((UserUR)this.getInstance()).getRoles().addAll(roles);
            return this;
        }
    }
}

