/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.commons;

import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;

public class NSStatusManagement
extends AttributeStatusManagement {
    private static final Log LOG = Log.getLog(NSStatusManagement.class);

    @Override
    protected String getStatusAttrName() {
        return "nsAccountLock";
    }

    @Override
    protected String getStatusAttrActiveValue() {
        return "false";
    }

    @Override
    protected String getStatusAttrInactiveValue() {
        return "true";
    }

    @Override
    public void setStatus(boolean status, Attributes attributes) {
        LOG.ok("Calling setStatus {0}", new Object[]{status});
        String value = status ? this.getStatusAttrActiveValue() : this.getStatusAttrInactiveValue();
        attributes.remove(this.getStatusAttrName());
        attributes.put(this.getStatusAttrName(), value);
    }

    @Override
    public void setStatus(boolean status, Set<AttributeDelta> modifications) {
        LOG.ok("Calling setStatus {0}", new Object[]{status});
        modifications.add(AttributeDeltaBuilder.build((String)this.getStatusAttrName(), (Object[])new Object[]{status ? this.getStatusAttrActiveValue() : this.getStatusAttrInactiveValue()}));
    }

    @Override
    public Boolean getStatus(Attributes attributes) {
        Boolean status = Boolean.TRUE;
        Attribute statusAttr = attributes.get(this.getStatusAttrName());
        if (statusAttr != null) {
            try {
                Object value = statusAttr.get();
                if (value != null) {
                    status = status ^ this.getStatusAttrInactiveValue().equalsIgnoreCase(value.toString());
                }
            }
            catch (NamingException ignore) {
                status = null;
            }
        }
        LOG.ok("Returning getStatus {0}", new Object[]{status});
        return status;
    }
}

