/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.common.lib.types.FlowableEntitlement;
import org.apache.syncope.core.flowable.impl.FlowableDeployUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.impl.db.DbIdGenerator;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FlowableLoader
implements SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(FlowableLoader.class);
    protected final Resource userWorkflowDef;
    protected final DomainProcessEngine dpEngine;

    public FlowableLoader(Resource userWorkflowDef, DomainProcessEngine dpEngine) {
        this.userWorkflowDef = userWorkflowDef;
        this.dpEngine = dpEngine;
    }

    public int getOrder() {
        return 310;
    }

    public void load() {
        EntitlementsHolder.getInstance().addAll((Collection)FlowableEntitlement.values());
    }

    public void load(String domain) {
        byte[] wfDef = new byte[]{};
        try (InputStream wfIn = this.userWorkflowDef.getInputStream();){
            wfDef = wfIn.readAllBytes();
        }
        catch (IOException e) {
            LOG.error("While loading {}", (Object)this.userWorkflowDef.getFilename(), (Object)e);
        }
        ProcessEngine processEngine = (ProcessEngine)this.dpEngine.getEngines().get(domain);
        if (processEngine == null) {
            LOG.error("Could not find the configured ProcessEngine for domain {}", (Object)domain);
        } else {
            List processes = processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("userWorkflow").list();
            LOG.debug("userWorkflow Flowable processes in repository: {}", (Object)processes);
            if (processes.isEmpty()) {
                processEngine.getRepositoryService().createDeployment().addInputStream(this.userWorkflowDef.getFilename(), (InputStream)new ByteArrayInputStream(wfDef)).deploy();
                ProcessDefinition procDef = (ProcessDefinition)processEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("userWorkflow").latestVersion().singleResult();
                FlowableDeployUtils.deployModel((ProcessEngine)processEngine, (ProcessDefinition)procDef);
                LOG.debug("Flowable Workflow definition loaded for domain {}", (Object)domain);
                if (processEngine.getProcessEngineConfiguration().getIdGenerator() instanceof DbIdGenerator) {
                    for (int i = 0; i < processEngine.getProcessEngineConfiguration().getIdBlockSize(); ++i) {
                        processEngine.getProcessEngineConfiguration().getIdGenerator().getNextId();
                    }
                }
            }
        }
    }
}

