/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.lang.invoke.LambdaMetafactory;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.StoppableSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.pushpull.AnyPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.SyncopeResultHandlerDispatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;

public class PullJobDelegate
extends AbstractPullExecutor<PullTask>
implements SyncopePullExecutor,
StoppableSchedTaskJobDelegate {
    protected Optional<ReconFilterBuilder> perContextReconFilterBuilder = Optional.empty();

    protected ReconFilterBuilder getReconFilterBuilder(PullTask task) throws ClassNotFoundException {
        return (ReconFilterBuilder)ImplementationManager.build((Implementation)task.getReconFilterBuilder(), () -> this.perContextReconFilterBuilder.orElse(null), instance -> {
            this.perContextReconFilterBuilder = Optional.of(instance);
        });
    }

    @Override
    protected void init(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        super.init(taskType, taskKey, context);
        this.profile = new ProvisioningProfile(this.connector, taskType, (ProvisioningTask)((PullTask)this.task), Optional.ofNullable(((PullTask)this.task).getResource().getInboundPolicy()).map(ProvisioningPolicy::getConflictResolutionAction).orElse(ConflictResolutionAction.IGNORE), this.getInboundActions(((PullTask)this.task).getActions()), this.executor, context.isDryRun());
        this.dispatcher = this.buildDispatcher();
    }

    public void stop() {
        Optional.ofNullable(this.dispatcher).ifPresent(SyncopeResultHandlerDispatcher::stop);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        PullJobDelegate.LOG.debug("Executing pull on {}", (Object)((PullTask)this.task).getResource());
        if (!this.profile.isDryRun()) {
            for (InboundActions action : this.profile.getActions()) {
                action.beforeAll(this.profile);
            }
        }
        if (((PullTask)this.task).getResource().getOrgUnit() != null) {
            this.setStatus("Pulling " + ((PullTask)this.task).getResource().getOrgUnit().getObjectClass());
            orgUnit = ((PullTask)this.task).getResource().getOrgUnit();
            moreAttrsToGet = new HashSet<E>();
            this.profile.getActions().forEach((Consumer<InboundActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecute$0(java.util.Set org.apache.syncope.common.lib.to.OrgUnit org.apache.syncope.core.provisioning.api.pushpull.InboundActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/InboundActions;)V)((PullJobDelegate)this, moreAttrsToGet, (OrgUnit)orgUnit));
            options = MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doExecute$1(int ), (I)[Ljava/lang/String;)()));
            this.dispatcher.addHandlerSupplier(orgUnit.getObjectClass(), (Supplier<SyncopePullResultHandler>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$2(), ()Lorg/apache/syncope/core/provisioning/api/pushpull/SyncopePullResultHandler;)((PullJobDelegate)this));
            try {
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$PullMode[((PullTask)this.task).getPullMode().ordinal()]) {
                    case 1: {
                        if (!context.isDryRun()) {
                            this.setLatestSyncToken(orgUnit.getObjectClass(), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()));
                        }
                        this.connector.sync(new ObjectClass(orgUnit.getObjectClass()), ConnObjectUtils.toSyncToken(orgUnit.getSyncToken()), (SyncResultsHandler)this.dispatcher, options);
                        if (!context.isDryRun()) {
                            orgUnit.setSyncToken(ConnObjectUtils.toString((SyncToken)this.latestSyncTokens.get(orgUnit.getObjectClass())));
                            this.resourceDAO.save((Entity)((PullTask)this.task).getResource());
                        }
                        break;
                    }
                    case 2: {
                        this.connector.filteredReconciliation(new ObjectClass(orgUnit.getObjectClass()), this.getReconFilterBuilder((PullTask)this.task), (SyncResultsHandler)this.dispatcher, options);
                        break;
                    }
                    default: {
                        this.connector.fullReconciliation(new ObjectClass(orgUnit.getObjectClass()), (SyncResultsHandler)this.dispatcher, options);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
        }
lbl35:
        // 7 sources

        block20: for (Provision provision : ((PullTask)this.task).getResource().getProvisions().stream().filter((Predicate<Provision>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecute$3(org.apache.syncope.common.lib.to.Provision ), (Lorg/apache/syncope/common/lib/to/Provision;)Z)()).sorted((Comparator<Provision>)this.provisionSorter).toList()) {
            this.setStatus("Pulling " + provision.getObjectClass());
            anyType = (AnyType)this.anyTypeDAO.findById(provision.getAnyType()).orElseThrow((Supplier<NotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$4(org.apache.syncope.common.lib.to.Provision ), ()Lorg/apache/syncope/core/persistence/api/dao/NotFoundException;)((Provision)provision));
            this.dispatcher.addHandlerSupplier(provision.getObjectClass(), (Supplier<SyncopePullResultHandler>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$5(org.apache.syncope.core.persistence.api.entity.AnyType ), ()Lorg/apache/syncope/core/provisioning/api/pushpull/SyncopePullResultHandler;)((PullJobDelegate)this, (AnyType)anyType));
            setSyncTokens = false;
            try {
                moreAttrsToGet = new HashSet<E>();
                this.profile.getActions().forEach((Consumer<InboundActions>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecute$6(java.util.Set org.apache.syncope.common.lib.to.Provision org.apache.syncope.core.provisioning.api.pushpull.InboundActions ), (Lorg/apache/syncope/core/provisioning/api/pushpull/InboundActions;)V)((PullJobDelegate)this, moreAttrsToGet, (Provision)provision));
                options = MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(provision.getMapping().getItems().stream()), (String[])moreAttrsToGet.toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$doExecute$7(int ), (I)[Ljava/lang/String;)()));
                switch (1.$SwitchMap$org$apache$syncope$common$lib$types$PullMode[((PullTask)this.task).getPullMode().ordinal()]) {
                    case 1: {
                        if (!context.isDryRun()) {
                            this.setLatestSyncToken(provision.getObjectClass(), ConnObjectUtils.toSyncToken(provision.getSyncToken()));
                        }
                        this.connector.sync(new ObjectClass(provision.getObjectClass()), ConnObjectUtils.toSyncToken(provision.getSyncToken()), (SyncResultsHandler)this.dispatcher, options);
                        if (context.isDryRun()) continue block20;
                        setSyncTokens = true;
                        ** break;
                    }
                    case 2: {
                        this.connector.filteredReconciliation(new ObjectClass(provision.getObjectClass()), this.getReconFilterBuilder((PullTask)this.task), (SyncResultsHandler)this.dispatcher, options);
                        ** break;
                    }
                    default: {
                        this.connector.fullReconciliation(new ObjectClass(provision.getObjectClass()), (SyncResultsHandler)this.dispatcher, options);
                        continue block20;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
            finally {
                if (!setSyncTokens) continue;
                this.latestSyncTokens.forEach((BiConsumer<String, SyncToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$doExecute$8(java.lang.String org.identityconnectors.framework.common.objects.SyncToken ), (Ljava/lang/String;Lorg/identityconnectors/framework/common/objects/SyncToken;)V)((PullJobDelegate)this));
                this.resourceDAO.save((Entity)((PullTask)this.task).getResource());
            }
        }
        this.dispatcher.shutdown();
        for (Provision provision : ((PullTask)this.task).getResource().getProvisions().stream().filter((Predicate<Provision>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecute$12(org.apache.syncope.common.lib.to.Provision ), (Lorg/apache/syncope/common/lib/to/Provision;)Z)()).sorted((Comparator<Provision>)this.provisionSorter).toList()) {
            if (provision.getUidOnCreate() != null) {
                try {
                    anyType = (AnyType)this.anyTypeDAO.findById(provision.getAnyType()).orElseThrow((Supplier<NotFoundException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doExecute$13(org.apache.syncope.common.lib.to.Provision ), ()Lorg/apache/syncope/core/persistence/api/dao/NotFoundException;)((Provision)provision));
                    anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
                    this.profile.getResults().stream().filter((Predicate<ProvisioningReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doExecute$14(org.apache.syncope.common.lib.to.Provision org.apache.syncope.common.lib.to.ProvisioningReport ), (Lorg/apache/syncope/common/lib/to/ProvisioningReport;)Z)((Provision)provision)).forEach((Consumer<ProvisioningReport>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$doExecute$15(org.apache.syncope.core.persistence.api.entity.AnyUtils org.apache.syncope.common.lib.to.Provision org.apache.syncope.common.lib.to.ProvisioningReport ), (Lorg/apache/syncope/common/lib/to/ProvisioningReport;)V)((PullJobDelegate)this, (AnyUtils)anyUtils, (Provision)provision));
                }
                catch (Throwable t) {
                    PullJobDelegate.LOG.error("While setting UID on create", t);
                }
            }
            handler = (AnyPullResultHandler)this.dispatcher.nonConcurrentHandler(provision.getObjectClass());
            try {
                handler.setManagers();
            }
            catch (Exception e) {
                PullJobDelegate.LOG.error("While setting managers", (Throwable)e);
            }
        }
        if (!this.profile.isDryRun()) {
            for (InboundActions action : this.profile.getActions()) {
                action.afterAll(this.profile);
            }
        }
        this.setStatus("Pull done");
        result = this.createReport(this.profile.getResults(), ((PullTask)this.task).getResource(), context.isDryRun());
        PullJobDelegate.LOG.debug("Pull result: {}", (Object)result);
        return result;
    }

    private /* synthetic */ void lambda$doExecute$15(AnyUtils anyUtils, Provision provision, ProvisioningReport result) {
        anyUtils.addAttr(this.validator, result.getKey(), (PlainSchema)this.plainSchemaDAO.findById(provision.getUidOnCreate()).orElseThrow(() -> new NotFoundException("PlainSchema " + provision.getUidOnCreate())), result.getUidValue());
    }

    private static /* synthetic */ boolean lambda$doExecute$14(Provision provision, ProvisioningReport result) {
        return result.getUidValue() != null && result.getKey() != null && result.getOperation() == ResourceOperation.CREATE && result.getAnyType().equals(provision.getAnyType());
    }

    private static /* synthetic */ NotFoundException lambda$doExecute$13(Provision provision) {
        return new NotFoundException("AnyType" + provision.getAnyType());
    }

    private static /* synthetic */ boolean lambda$doExecute$12(Provision provision) {
        return provision.getMapping() != null;
    }

    private /* synthetic */ void lambda$doExecute$8(String objectClass, SyncToken syncToken) {
        ((PullTask)this.task).getResource().getProvisionByObjectClass(objectClass).ifPresent(p -> p.setSyncToken(ConnObjectUtils.toString(syncToken)));
        Optional.ofNullable(((PullTask)this.task).getResource().getOrgUnit()).filter(ou -> objectClass.equals(ou.getObjectClass())).ifPresent(ou -> ou.setSyncToken(ConnObjectUtils.toString(syncToken)));
    }

    private static /* synthetic */ String[] lambda$doExecute$7(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doExecute$6(Set moreAttrsToGet, Provision provision, InboundActions a) {
        moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision));
    }

    private /* synthetic */ SyncopePullResultHandler lambda$doExecute$5(AnyType anyType) {
        AnyPullResultHandler handler = switch (anyType.getKind()) {
            case AnyTypeKind.USER -> this.buildUserHandler();
            case AnyTypeKind.GROUP -> this.buildGroupHandler();
            default -> this.buildAnyObjectHandler();
        };
        handler.setProfile(this.profile);
        return handler;
    }

    private static /* synthetic */ NotFoundException lambda$doExecute$4(Provision provision) {
        return new NotFoundException("AnyType" + provision.getAnyType());
    }

    private static /* synthetic */ boolean lambda$doExecute$3(Provision provision) {
        return provision.getMapping() != null;
    }

    private /* synthetic */ SyncopePullResultHandler lambda$doExecute$2() {
        RealmPullResultHandler handler = this.buildRealmHandler();
        handler.setProfile(this.profile);
        return handler;
    }

    private static /* synthetic */ String[] lambda$doExecute$1(int x$0) {
        return new String[x$0];
    }

    private /* synthetic */ void lambda$doExecute$0(Set moreAttrsToGet, OrgUnit orgUnit, InboundActions a) {
        moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, orgUnit));
    }
}

