/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.TransactionSettingsBackendLockBehavior;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TransactionSettingsScopedLockDetails
implements Serializable {
    private static final byte TYPE_SCOPE_IDENTIFIER = -119;
    private static final byte TYPE_LOCK_BEHAVIOR = -118;
    private static final long serialVersionUID = -1374000956873071172L;
    @NotNull
    private final String scopeIdentifier;
    @NotNull
    private final TransactionSettingsBackendLockBehavior lockBehavior;

    public TransactionSettingsScopedLockDetails(@NotNull String scopeIdentifier, @NotNull TransactionSettingsBackendLockBehavior lockBehavior) {
        this.scopeIdentifier = scopeIdentifier;
        this.lockBehavior = lockBehavior;
    }

    @NotNull
    public String getScopeIdentifier() {
        return this.scopeIdentifier;
    }

    @NotNull
    public TransactionSettingsBackendLockBehavior getLockBehavior() {
        return this.lockBehavior;
    }

    @Nullable
    public ASN1Element encode() {
        if (this.lockBehavior == TransactionSettingsBackendLockBehavior.DO_NOT_ACQUIRE) {
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(-119, this.scopeIdentifier));
        elements.add(new ASN1Enumerated(-118, this.lockBehavior.intValue()));
        return new ASN1Sequence(-88, elements);
    }

    @Nullable
    public static TransactionSettingsScopedLockDetails decode(@Nullable ASN1Element element) throws LDAPException {
        if (element == null) {
            return null;
        }
        try {
            ASN1Element[] elements = element.decodeAsSequence().elements();
            String scopeIdentifier = elements[0].decodeAsOctetString().stringValue();
            int lockBehaviorIntValue = elements[1].decodeAsEnumerated().intValue();
            TransactionSettingsBackendLockBehavior lockBehavior = TransactionSettingsBackendLockBehavior.valueOf(lockBehaviorIntValue);
            return new TransactionSettingsScopedLockDetails(scopeIdentifier, lockBehavior);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PROTOCOL_ERROR, ControlMessages.ERR_TXN_SETTINGS_SCOPED_LOCK_DETAILS_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TransactionSettingsScopedLockDetails(scopeIdentifier='");
        buffer.append(this.scopeIdentifier);
        buffer.append("', lockBehavior='");
        buffer.append(this.lockBehavior.name());
        buffer.append("')");
    }
}

