/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.forgerockds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.forgerockds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class W3CTraceContextRequestControl
extends Control {
    @NotNull
    public static final String W3C_TRACE_CONTEXT_REQUEST_OID = "1.3.6.1.4.1.36733.2.1.5.7";
    @NotNull
    private static final String JSON_FIELD_TRACE_PARENT = "trace-parent";
    @NotNull
    private static final String JSON_FIELD_TRACE_STATE = "trace-state";
    private static final long serialVersionUID = -4086202983109938297L;
    @NotNull
    private final String traceParent;
    @Nullable
    private final String traceState;

    public W3CTraceContextRequestControl(@NotNull String traceParent, @Nullable String traceState) {
        this(traceParent, traceState, false);
    }

    public W3CTraceContextRequestControl(@NotNull String traceParent, @Nullable String traceState, boolean isCritical) {
        super(W3C_TRACE_CONTEXT_REQUEST_OID, isCritical, W3CTraceContextRequestControl.encodeValue(traceParent, traceState));
        this.traceParent = traceParent;
        this.traceState = traceState;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String traceParent, @Nullable String traceState) {
        Validator.ensureNotNullWithMessage(traceParent, "W3CTraceContextRequestControl.traceParent must not be null");
        ArrayList<ASN1OctetString> valueElements = new ArrayList<ASN1OctetString>(2);
        valueElements.add(new ASN1OctetString(traceParent));
        if (traceState != null) {
            valueElements.add(new ASN1OctetString(traceState));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(valueElements);
        return new ASN1OctetString(valueSequence.encode());
    }

    public W3CTraceContextRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_WC3_TRACE_CONTEXT_REQUST_NO_VALUE.get());
        }
        try {
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            ASN1Element[] valueElements = valueSequence.elements();
            this.traceParent = valueElements[0].decodeAsOctetString().stringValue();
            this.traceState = valueElements.length > 1 ? valueElements[1].decodeAsOctetString().stringValue() : null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_WC3_TRACE_CONTEXT_REQUST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String getTraceParent() {
        return this.traceParent;
    }

    @NotNull
    public String getTraceState() {
        return this.traceState;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_WC3_TRACE_CONTEXT_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_TRACE_PARENT, new JSONString(this.traceParent));
        if (this.traceState != null) {
            valueFields.put(JSON_FIELD_TRACE_STATE, new JSONString(this.traceState));
        }
        return new JSONObject(new JSONField("oid", W3C_TRACE_CONTEXT_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_WC3_TRACE_CONTEXT_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static W3CTraceContextRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new W3CTraceContextRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String traceParent = valueObject.getFieldAsString(JSON_FIELD_TRACE_PARENT);
        if (traceParent == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_WC3_TRACE_CONTEXT_REQUEST_MISSING_JSON_TRACE_PARENT.get(JSON_FIELD_TRACE_PARENT));
        }
        String traceState = valueObject.getFieldAsString(JSON_FIELD_TRACE_STATE);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_TRACE_PARENT, JSON_FIELD_TRACE_STATE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_WC3_TRACE_CONTEXT_REQUEST_UNRECOGNIZED_JSON_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new W3CTraceContextRequestControl(traceParent, traceState, jsonControl.getCriticality());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("W3CTraceContextRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", traceParent='");
        buffer.append(this.traceParent);
        buffer.append('\'');
        if (this.traceState != null) {
            buffer.append(", traceState='");
            buffer.append(this.traceState);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

