/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.api.PasswordlessUserAccountCustomizer;
import org.apereo.cas.api.PasswordlessUserAccountStore;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.syncope.passwordless.SyncopePasswordlessUserAccountStore;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordlessAuthn}, module="syncope")
@ConditionalOnClass(value={PasswordlessUserAccountStore.class})
@Configuration(value="SyncopePasswordlessAuthenticationConfiguration", proxyBeanMethods=false)
class SyncopePasswordlessAuthenticationConfiguration {
    SyncopePasswordlessAuthenticationConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"syncopePasswordlessUserAccountStore"})
    public BeanSupplier<PasswordlessUserAccountStore> syncopePasswordlessUserAccountStore(List<PasswordlessUserAccountCustomizer> customizerList, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return BeanSupplier.of(PasswordlessUserAccountStore.class).when(BeanCondition.on((String)"cas.authn.passwordless.accounts.syncope.url").isUrl().given((ApplicationContext)applicationContext)).supply(() -> new SyncopePasswordlessUserAccountStore(customizerList, casProperties.getAuthn().getPasswordless().getAccounts().getSyncope())).otherwiseNull();
    }
}

