/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.history.HistoricDetail;
import org.flowable.engine.impl.HistoricDetailQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.ActivityInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricDetailDataManager;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class HistoricDetailEntityManagerImpl
extends AbstractProcessEngineEntityManager<HistoricDetailEntity, HistoricDetailDataManager>
implements HistoricDetailEntityManager {
    public HistoricDetailEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, HistoricDetailDataManager historicDetailDataManager) {
        super(processEngineConfiguration, historicDetailDataManager);
    }

    @Override
    public HistoricFormPropertyEntity insertHistoricFormPropertyEntity(ExecutionEntity execution, String propertyId, String propertyValue, String taskId, Date createTime) {
        HistoricFormPropertyEntity historicFormPropertyEntity = ((HistoricDetailDataManager)this.dataManager).createHistoricFormProperty();
        historicFormPropertyEntity.setProcessInstanceId(execution.getProcessInstanceId());
        historicFormPropertyEntity.setExecutionId(execution.getId());
        historicFormPropertyEntity.setTaskId(taskId);
        historicFormPropertyEntity.setPropertyId(propertyId);
        historicFormPropertyEntity.setPropertyValue(propertyValue);
        historicFormPropertyEntity.setTime(createTime);
        ActivityInstanceEntity activityInstance = this.getActivityInstanceEntityManager().findUnfinishedActivityInstance(execution);
        if (activityInstance == null) {
            throw new FlowableException("ActivityInstance not found for " + String.valueOf(execution));
        }
        String activityInstanceId = activityInstance.getId();
        historicFormPropertyEntity.setActivityInstanceId(activityInstanceId);
        this.insert(historicFormPropertyEntity);
        return historicFormPropertyEntity;
    }

    @Override
    public HistoricDetailVariableInstanceUpdateEntity copyAndInsertHistoricDetailVariableInstanceUpdateEntity(VariableInstanceEntity variableInstance, Date createTime) {
        HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = ((HistoricDetailDataManager)this.dataManager).createHistoricDetailVariableInstanceUpdate();
        historicVariableUpdate.setProcessInstanceId(variableInstance.getProcessInstanceId());
        historicVariableUpdate.setExecutionId(variableInstance.getExecutionId());
        historicVariableUpdate.setTaskId(variableInstance.getTaskId());
        historicVariableUpdate.setTime(createTime);
        historicVariableUpdate.setRevision(variableInstance.getRevision());
        historicVariableUpdate.setName(variableInstance.getName());
        historicVariableUpdate.setVariableType(variableInstance.getType());
        historicVariableUpdate.setTextValue(variableInstance.getTextValue());
        historicVariableUpdate.setTextValue2(variableInstance.getTextValue2());
        historicVariableUpdate.setDoubleValue(variableInstance.getDoubleValue());
        historicVariableUpdate.setLongValue(variableInstance.getLongValue());
        if (variableInstance.getBytes() != null) {
            historicVariableUpdate.setBytes(variableInstance.getBytes());
        }
        this.insert(historicVariableUpdate);
        return historicVariableUpdate;
    }

    public void delete(HistoricDetailEntity entity, boolean fireDeleteEvent) {
        HistoricDetailVariableInstanceUpdateEntity historicDetailVariableInstanceUpdateEntity;
        super.delete((Entity)entity, fireDeleteEvent);
        if (entity instanceof HistoricDetailVariableInstanceUpdateEntity && (historicDetailVariableInstanceUpdateEntity = (HistoricDetailVariableInstanceUpdateEntity)entity).getByteArrayRef() != null) {
            historicDetailVariableInstanceUpdateEntity.getByteArrayRef().delete(((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
    }

    @Override
    public void deleteHistoricDetailsByProcessInstanceId(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List<HistoricDetailEntity> historicDetails = ((HistoricDetailDataManager)this.dataManager).findHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            for (HistoricDetailEntity historicDetail : historicDetails) {
                this.delete(historicDetail);
            }
        }
    }

    @Override
    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return ((HistoricDetailDataManager)this.dataManager).findHistoricDetailCountByQueryCriteria(historicVariableUpdateQuery);
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return ((HistoricDetailDataManager)this.dataManager).findHistoricDetailsByQueryCriteria(historicVariableUpdateQuery);
    }

    @Override
    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            List<HistoricDetailEntity> details = ((HistoricDetailDataManager)this.dataManager).findHistoricDetailsByTaskId(taskId);
            for (HistoricDetail historicDetail : details) {
                this.delete((HistoricDetailEntity)historicDetail);
            }
        }
    }

    @Override
    public void bulkDeleteHistoricDetailsByProcessInstanceIds(Collection<String> historicProcessInstanceIds) {
        ((HistoricDetailDataManager)this.dataManager).bulkDeleteHistoricDetailsByProcessInstanceIds(historicProcessInstanceIds);
    }

    @Override
    public void bulkDeleteHistoricDetailsByTaskIds(Collection<String> taskIds) {
        ((HistoricDetailDataManager)this.dataManager).bulkDeleteHistoricDetailsByTaskIds(taskIds);
    }

    @Override
    public void deleteHistoricDetailForNonExistingProcessInstances() {
        ((HistoricDetailDataManager)this.dataManager).deleteHistoricDetailForNonExistingProcessInstances();
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByNativeQuery(Map<String, Object> parameterMap) {
        return ((HistoricDetailDataManager)this.dataManager).findHistoricDetailsByNativeQuery(parameterMap);
    }

    @Override
    public long findHistoricDetailCountByNativeQuery(Map<String, Object> parameterMap) {
        return ((HistoricDetailDataManager)this.dataManager).findHistoricDetailCountByNativeQuery(parameterMap);
    }

    protected ActivityInstanceEntityManager getActivityInstanceEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getActivityInstanceEntityManager();
    }

    protected HistoryManager getHistoryManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getHistoryManager();
    }
}

