/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.button;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.ui.JQueryUIBehavior;
import org.wicketstuff.jquery.ui.form.button.ButtonBehavior;
import org.wicketstuff.jquery.ui.widget.menu.IMenuItem;
import org.wicketstuff.jquery.ui.widget.menu.Menu;

public abstract class AbstractSplitButton
extends GenericPanel<List<IMenuItem>> {
    private static final long serialVersionUID = 1L;
    private static final JavaScriptResourceReference SPLITBUTTON_JS = new JavaScriptResourceReference(AbstractSplitButton.class, "SplitButton.js");
    private WebMarkupContainer buttonset;
    private AbstractLink button;
    private boolean defaultFormProcessing = true;

    public AbstractSplitButton(String id, List<IMenuItem> items) {
        this(id, (IModel<List<IMenuItem>>)Model.ofList(items));
    }

    public AbstractSplitButton(String id, IModel<List<IMenuItem>> items) {
        super(id, items);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SPLITBUTTON_JS));
    }

    public boolean getDefaultFormProcessing() {
        return this.defaultFormProcessing;
    }

    public AbstractSplitButton setDefaultFormProcessing(boolean defaultFormProcessing) {
        this.defaultFormProcessing = defaultFormProcessing;
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buttonset = new WebMarkupContainer("buttonset");
        this.buttonset.setOutputMarkupId(true);
        this.add(new Component[]{this.buttonset});
        this.button = this.newLink("button");
        this.button.add(new Behavior[]{AbstractSplitButton.newButtonSetBehavior((Component)this.buttonset)});
        this.buttonset.add(new Component[]{this.button});
        this.buttonset.add(new Component[]{AbstractSplitButton.newMenuContainer("select")});
    }

    protected void onBeforeRender() {
        this.addOrReplace(new Component[]{this.newMenu("menu", (List)this.getModelObject())});
        super.onBeforeRender();
    }

    protected abstract AbstractLink newLink(String var1);

    private static JQueryUIBehavior newButtonSetBehavior(Component component) {
        return new JQueryUIBehavior(IJQueryWidget.JQueryWidget.getSelector((Component)component), "buttonset");
    }

    private static WebMarkupContainer newMenuContainer(String id) {
        WebMarkupContainer container = new WebMarkupContainer(id);
        container.add(new Behavior[]{new ButtonBehavior(IJQueryWidget.JQueryWidget.getSelector((Component)container)){
            private static final long serialVersionUID = 1L;

            public void bind(Component component) {
                super.bind(component);
                this.on("click", "function() { return showSplitButtonMenu(this); }");
            }

            @Override
            public void onConfigure(Component component) {
                super.onConfigure(component);
                this.setOption("text", false);
                this.setOption("icon", Options.asString((String)"ui-icon-triangle-1-s"));
            }
        }});
        return container;
    }

    private Menu newMenu(String id, List<IMenuItem> list) {
        return new Menu(id, list){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target, IMenuItem item) {
                AbstractSplitButton.this.button.setDefaultModelObject((Object)item);
                target.add(new Component[]{AbstractSplitButton.this.buttonset});
            }
        };
    }
}

