/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.NameValuePair;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20TokenAuthorizationResponseBuilder<T extends OAuth20ConfigurationContext>
extends BaseOAuth20AuthorizationResponseBuilder<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenAuthorizationResponseBuilder.class);

    public OAuth20TokenAuthorizationResponseBuilder(T configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(configurationContext, authorizationModelAndViewBuilder);
    }

    @Audit(action="OAUTH2_AUTHORIZATION_RESPONSE", actionResolverName="OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER", resourceResolverName="OAUTH2_AUTHORIZATION_RESPONSE_RESOURCE_RESOLVER")
    public ModelAndView build(AccessTokenRequestContext tokenRequestContext) throws Throwable {
        LOGGER.debug("Authorize request verification successful for client [{}] with redirect uri [{}]", (Object)tokenRequestContext.getClientId(), (Object)tokenRequestContext.getRedirectUri());
        OAuth20TokenGeneratedResult result = this.configurationContext.getAccessTokenGenerator().generate(tokenRequestContext);
        Ticket accessToken = (Ticket)result.getAccessToken().orElseThrow();
        Ticket refreshToken = result.getRefreshToken().orElse(null);
        LOGGER.debug("Generated OAuth access token: [{}]", (Object)accessToken);
        return this.buildCallbackUrlResponseType(tokenRequestContext, accessToken, refreshToken, new ArrayList<NameValuePair>());
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return Strings.CI.equals(context.getResponseType(), OAuth20ResponseTypes.TOKEN.getType());
    }

    protected ModelAndView buildCallbackUrlResponseType(AccessTokenRequestContext tokenRequestContext, Ticket givenAccessToken, Ticket givenRefreshToken, List<NameValuePair> parameters) throws Throwable {
        Map attributes = tokenRequestContext.getAuthentication().getAttributes();
        OAuth20AccessToken accessToken = this.resolveAccessToken(givenAccessToken);
        LinkedHashMap<String, String> paramsToBuild = new LinkedHashMap<String, String>();
        parameters.forEach(nvp -> paramsToBuild.put(nvp.getName(), nvp.getValue()));
        if (this.includeAccessTokenInResponse(tokenRequestContext) && accessToken.getExpiresIn() > 0L) {
            EncodableCipher<String, String> cipher = OAuth20JwtAccessTokenEncoder.toEncodableCipher(this.configurationContext, (RegisteredService)tokenRequestContext.getRegisteredService(), (OAuth20Token)accessToken, tokenRequestContext.getService(), false);
            String encodedAccessToken = (String)cipher.encode((Object)accessToken.getId());
            paramsToBuild.put("access_token", encodedAccessToken);
            paramsToBuild.put("token_type", "Bearer");
            paramsToBuild.put("expires_in", String.valueOf(accessToken.getExpiresIn()));
        }
        if (givenRefreshToken != null) {
            OAuth20RefreshToken refreshToken = this.resolveRefreshToken(givenRefreshToken);
            paramsToBuild.put("refresh_token", refreshToken.getId());
        }
        CollectionUtils.firstElement(attributes.get("state")).ifPresent(state -> paramsToBuild.put("state", state.toString()));
        CollectionUtils.firstElement(attributes.get("nonce")).ifPresent(nonce -> paramsToBuild.put("nonce", nonce.toString()));
        LOGGER.debug("Redirecting to URL [{}]", (Object)tokenRequestContext.getRedirectUri());
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.configurationContext.getServicesManager(), accessToken.getClientId());
        OAuth20ResponseModeTypes responseMode = tokenRequestContext.getResponseMode();
        if (responseMode == null || responseMode == OAuth20ResponseModeTypes.NONE) {
            responseMode = OAuth20ResponseModeTypes.FRAGMENT;
        }
        return this.build(registeredService, responseMode, tokenRequestContext.getRedirectUri(), paramsToBuild);
    }

    protected boolean includeAccessTokenInResponse(AccessTokenRequestContext tokenRequestContext) {
        return true;
    }
}

