/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.configuration.model.support.replication.SessionReplicationProperties;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.web.AbstractController;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuth20Controller<T extends OAuth20ConfigurationContext>
extends AbstractController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20Controller.class);
    protected final T configurationContext;

    protected OAuth20AccessToken resolveAccessToken(Ticket givenAccessToken) {
        return this.resolveToken(givenAccessToken, OAuth20AccessToken.class);
    }

    protected <U extends Ticket> U resolveToken(Ticket token, Class<U> clazz) {
        return (U)(token.isStateless() ? ((OAuth20ConfigurationContext)this.configurationContext).getTicketRegistry().getTicket(token.getId(), clazz) : (Ticket)clazz.cast(token));
    }

    protected String extractAccessTokenFrom(String token) {
        return (String)OAuth20JwtAccessTokenEncoder.toDecodableCipher(((OAuth20ConfigurationContext)this.getConfigurationContext()).getAccessTokenJwtBuilder()).decode((Object)token);
    }

    protected void ensureSessionReplicationIsAutoconfiguredIfNeedBe(HttpServletRequest request) {
        SessionReplicationProperties replicationProps = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getCasProperties().getAuthn().getPac4j().getCore().getSessionReplication();
        boolean cookieAutoconfigured = replicationProps.getCookie().isAutoConfigureCookiePath();
        if (replicationProps.isReplicateSessions() && cookieAutoconfigured) {
            CasCookieBuilder cookieBuilder = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getOauthDistributedSessionCookieGenerator();
            CookieUtils.configureCookiePath((HttpServletRequest)request, (CasCookieBuilder)cookieBuilder);
        }
    }

    protected boolean isRequestAuthenticated(ProfileManager manager, WebContext context, OAuthRegisteredService registeredService) {
        return manager.getProfile().isPresent();
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager(), clientId);
    }

    protected static boolean isRefreshToken(OAuth20Token token) {
        return token instanceof OAuth20RefreshToken;
    }

    protected static boolean isAccessToken(OAuth20Token token) {
        return token instanceof OAuth20AccessToken;
    }

    protected void revokeToken(OAuth20RefreshToken token) throws Exception {
        LOGGER.debug("Revoking refresh token [{}] and all associated access tokens", (Object)token.getId());
        token.getAccessTokens().removeIf(Unchecked.predicate(this::revokeToken));
        this.revokeToken(token.getId());
    }

    protected boolean revokeToken(String token) throws Exception {
        LOGGER.debug("Revoking token [{}]", (Object)token);
        return ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().deleteTicket(token) > 0;
    }

    @Generated
    protected BaseOAuth20Controller(T configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public T getConfigurationContext() {
        return this.configurationContext;
    }
}

