/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.mail;

import jakarta.mail.internet.MimeMessage;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.notifications.mail.EmailSender;
import org.apereo.cas.notifications.mail.EmailSenderCustomizer;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class DefaultEmailSender
implements EmailSender {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEmailSender.class);
    private final MessageSource messageSource;
    private final ApplicationContext applicationContext;
    private final List<EmailSenderCustomizer> emailSenderCustomizers;
    private final MailProperties mailProperties;
    private final ObjectProvider<SslBundles> sslBundles;
    private final TenantExtractor tenantExtractor;

    @Override
    public EmailCommunicationResult send(EmailMessageRequest emailRequest) throws Exception {
        JavaMailSenderImpl mailSender = this.createMailSender(emailRequest);
        boolean connectionAvailable = mailSender != null && (Boolean)FunctionUtils.doAndHandle(() -> {
            mailSender.testConnection();
            return true;
        }, throwable -> false).get() != false;
        List<String> recipients = emailRequest.getRecipients();
        if (connectionAvailable) {
            MimeMessage message = this.createEmailMessage(emailRequest, (JavaMailSender)mailSender);
            this.emailSenderCustomizers.forEach(customizer -> customizer.customize((JavaMailSender)mailSender, emailRequest));
            mailSender.send(message);
        }
        return ((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)((EmailCommunicationResult.EmailCommunicationResultBuilder)EmailCommunicationResult.builder().success(connectionAvailable)).to(recipients)).body(emailRequest.getBody())).build();
    }

    protected MimeMessage createEmailMessage(EmailMessageRequest emailRequest, JavaMailSender mailSender) throws Exception {
        List<String> recipients = emailRequest.getRecipients();
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(message);
        messageHelper.setTo(recipients.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        EmailProperties emailProperties = emailRequest.getEmailProperties();
        messageHelper.setText(emailRequest.getBody(), emailProperties.isHtml());
        String subject = this.determineEmailSubject(emailRequest, this.messageSource);
        messageHelper.setSubject(subject);
        messageHelper.setFrom(emailProperties.getFrom());
        FunctionUtils.doIfNotBlank((CharSequence)emailProperties.getReplyTo(), arg_0 -> ((MimeMessageHelper)messageHelper).setReplyTo(arg_0));
        messageHelper.setValidateAddresses(emailProperties.isValidateAddresses());
        messageHelper.setPriority(emailProperties.getPriority());
        messageHelper.setCc(emailProperties.getCc().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        messageHelper.setBcc(emailProperties.getBcc().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        return message;
    }

    protected JavaMailSenderImpl createMailSender(EmailMessageRequest emailRequest) {
        JavaMailSenderImpl sender = this.applyProperties(new JavaMailSenderImpl(), emailRequest);
        return StringUtils.isNotBlank((CharSequence)sender.getHost()) ? sender : null;
    }

    protected JavaMailSenderImpl applyProperties(JavaMailSenderImpl sender, EmailMessageRequest emailRequest) {
        MailProperties effectiveProperties = this.findTenantEmailProperties(emailRequest);
        sender.setHost(effectiveProperties.getHost());
        if (effectiveProperties.getPort() != null) {
            sender.setPort(effectiveProperties.getPort().intValue());
        }
        sender.setUsername(effectiveProperties.getUsername());
        sender.setPassword(effectiveProperties.getPassword());
        sender.setProtocol(effectiveProperties.getProtocol());
        sender.setDefaultEncoding(effectiveProperties.getDefaultEncoding().name());
        Properties javaMailProperties = DefaultEmailSender.asProperties(effectiveProperties.getProperties());
        String protocol = (String)StringUtils.defaultIfBlank((CharSequence)effectiveProperties.getProtocol(), (CharSequence)"smtp");
        MailProperties.Ssl ssl = effectiveProperties.getSsl();
        if (ssl.isEnabled()) {
            javaMailProperties.setProperty("mail." + protocol + ".ssl.enable", "true");
        }
        if (StringUtils.isNotBlank((CharSequence)ssl.getBundle())) {
            SslBundle sslBundle = ((SslBundles)this.sslBundles.getObject()).getBundle(ssl.getBundle());
            SSLSocketFactory socketFactory = sslBundle.createSslContext().getSocketFactory();
            javaMailProperties.put("mail." + protocol + ".ssl.socketFactory", socketFactory);
        }
        if (!javaMailProperties.isEmpty()) {
            sender.setJavaMailProperties(javaMailProperties);
        }
        return sender;
    }

    protected MailProperties findTenantEmailProperties(EmailMessageRequest emailMessageRequest) {
        return this.tenantExtractor.getTenantsManager().findTenant(emailMessageRequest.getTenant()).map(tenantDefinition -> tenantDefinition.bindPropertiesTo(MailProperties.class)).filter(ConfigurationPropertiesBindingContext::isBound).filter(bindingContext -> bindingContext.containsBindingFor(MailProperties.class)).map(ConfigurationPropertiesBindingContext::value).orElse(this.mailProperties);
    }

    private static Properties asProperties(Map<String, String> source) {
        Properties properties = new Properties();
        properties.putAll(source);
        return properties;
    }

    @Generated
    public DefaultEmailSender(MessageSource messageSource, ApplicationContext applicationContext, List<EmailSenderCustomizer> emailSenderCustomizers, MailProperties mailProperties, ObjectProvider<SslBundles> sslBundles, TenantExtractor tenantExtractor) {
        this.messageSource = messageSource;
        this.applicationContext = applicationContext;
        this.emailSenderCustomizers = emailSenderCustomizers;
        this.mailProperties = mailProperties;
        this.sslBundles = sslBundles;
        this.tenantExtractor = tenantExtractor;
    }

    @Generated
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public List<EmailSenderCustomizer> getEmailSenderCustomizers() {
        return this.emailSenderCustomizers;
    }

    @Generated
    public MailProperties getMailProperties() {
        return this.mailProperties;
    }

    @Generated
    public ObjectProvider<SslBundles> getSslBundles() {
        return this.sslBundles;
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }
}

