/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.core.authentication.AuthenticationHandlerStates;
import org.apereo.cas.util.NamedObject;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.Ordered;

@FunctionalInterface
public interface AuthenticationHandler
extends Ordered,
NamedObject {
    public static final String SUCCESSFUL_AUTHENTICATION_HANDLERS = "successfulAuthenticationHandlers";

    public static AuthenticationHandler disabled() {
        return new AuthenticationHandler(){

            @Override
            public AuthenticationHandlerExecutionResult authenticate(Credential credential, Service service) throws PreventedException {
                throw new PreventedException("Authentication handler is disabled");
            }

            @Override
            public boolean supports(Credential credential) {
                return false;
            }

            @Override
            public boolean supports(Class<? extends Credential> clazz) {
                return false;
            }
        };
    }

    public AuthenticationHandlerExecutionResult authenticate(Credential var1, Service var2) throws Throwable;

    default public boolean supports(Credential credential) {
        return false;
    }

    default public boolean supports(Class<? extends Credential> clazz) {
        return false;
    }

    default public int getOrder() {
        return Integer.MAX_VALUE;
    }

    default public AuthenticationHandlerStates getState() {
        return AuthenticationHandlerStates.ACTIVE;
    }

    default public Map<String, Serializable> getTags() {
        return Map.of();
    }

    default public boolean isDisposable() {
        return this instanceof DisposableBean && BooleanUtils.isTrue((Boolean)((Boolean)this.getTags().getOrDefault(DisposableBean.class.getName(), Boolean.FALSE)));
    }

    @CanIgnoreReturnValue
    default public AuthenticationHandler markDisposable() {
        this.getTags().put(DisposableBean.class.getName(), Boolean.TRUE);
        return this;
    }
}

