/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class SpringBeanWebFlowELResolver
extends ELResolver {
    private static final Log logger = LogFactory.getLog(SpringBeanWebFlowELResolver.class);
    private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();
    private RequestContext requestContext;

    public SpringBeanWebFlowELResolver() {
    }

    public SpringBeanWebFlowELResolver(RequestContext context) {
        this.requestContext = context;
    }

    protected BeanFactory getBeanFactory(ELContext elContext) {
        RequestContext requestContext = this.getRequestContext();
        if (requestContext == null) {
            return EMPTY_BEAN_FACTORY;
        }
        ApplicationContext beanFactory = requestContext.getActiveFlow().getApplicationContext();
        return beanFactory != null ? beanFactory : EMPTY_BEAN_FACTORY;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext != null ? this.requestContext : RequestContextHolder.getRequestContext();
    }

    public Object getValue(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Successfully resolved variable '" + beanName + "' in Spring BeanFactory"));
                }
                elContext.setPropertyResolved(true);
                return bf.getBean(beanName);
            }
        }
        return null;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                elContext.setPropertyResolved(true);
                return bf.getType(beanName);
            }
        }
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                if (value == bf.getBean(beanName)) {
                    elContext.setPropertyResolved(true);
                } else {
                    throw new PropertyNotWritableException("Variable '" + beanName + "' refers to a Spring bean which by definition is not writable");
                }
            }
        }
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) throws ELException {
        if (base == null) {
            String beanName = property.toString();
            BeanFactory bf = this.getBeanFactory(elContext);
            if (bf.containsBean(beanName)) {
                return true;
            }
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return Object.class;
    }
}

