/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.csrf;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.csrf.CsrfAttacksPreventionProperties;
import lombok.Generated;
import org.apache.wicket.protocol.http.FetchMetadataResourceIsolationPolicy;
import org.apache.wicket.protocol.http.IResourceIsolationPolicy;
import org.apache.wicket.protocol.http.OriginResourceIsolationPolicy;
import org.apache.wicket.protocol.http.ResourceIsolationRequestCycleListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.csrf", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ResourceIsolationRequestCycleListener.class})
@EnableConfigurationProperties(value={CsrfAttacksPreventionProperties.class})
public class CsrfAttacksPreventionConfig
implements WicketApplicationInitConfiguration {
    private final CsrfAttacksPreventionProperties props;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        OriginResourceIsolationPolicy originResourceIsolationPolicy = new OriginResourceIsolationPolicy();
        this.props.getAcceptedOrigins().forEach(arg_0 -> ((OriginResourceIsolationPolicy)originResourceIsolationPolicy).addAcceptedOrigin(arg_0));
        ResourceIsolationRequestCycleListener listener = new ResourceIsolationRequestCycleListener(new IResourceIsolationPolicy[]{new FetchMetadataResourceIsolationPolicy(), originResourceIsolationPolicy});
        listener.setUnknownOutcomeAction(this.props.getUnknownOutcomeAction());
        listener.setDisallowedOutcomeAction(this.props.getDisallowedOutcomeAction());
        listener.setErrorCode(this.props.getErrorCode());
        listener.setErrorMessage(this.props.getErrorMessage());
        webApplication.getRequestCycleListeners().add((Object)listener);
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    @Generated
    public CsrfAttacksPreventionConfig(CsrfAttacksPreventionProperties props, WicketEndpointRepository wicketEndpointRepository) {
        this.props = props;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

