/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.artifact;

import java.io.StringWriter;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.artifact.SamlArtifactTicket;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketFactory;
import org.apereo.cas.ticket.artifact.SamlArtifactTicketImpl;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;

public class DefaultSamlArtifactTicketFactory
implements SamlArtifactTicketFactory {
    protected final ExpirationPolicyBuilder<SamlArtifactTicket> expirationPolicyBuilder;
    protected final OpenSamlConfigBean configBean;
    protected final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    protected final TicketTrackingPolicy descendantTicketsTrackingPolicy;
    protected final UniqueTicketIdGenerator ticketIdGenerator = UniqueTicketIdGenerator.prefixedTicketIdGenerator();

    @Override
    public SamlArtifactTicket create(String artifactId, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, String issuer, String relyingParty, SAMLObject samlObject) {
        return (SamlArtifactTicket)FunctionUtils.doUnchecked(() -> {
            try (StringWriter w = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configBean, (XMLObject)samlObject);){
                String codeId = this.createTicketIdFor(artifactId);
                WebApplicationService service = (WebApplicationService)this.webApplicationServiceFactory.createService(relyingParty);
                SamlArtifactTicketImpl at = new SamlArtifactTicketImpl(codeId, (Service)service, authentication, this.expirationPolicyBuilder.buildTicketExpirationPolicy(), ticketGrantingTicket, issuer, relyingParty, w.toString());
                this.descendantTicketsTrackingPolicy.trackTicket((Ticket)ticketGrantingTicket, (Ticket)at);
                SamlArtifactTicketImpl samlArtifactTicketImpl = at;
                return samlArtifactTicketImpl;
            }
        });
    }

    public Class<? extends Ticket> getTicketType() {
        return SamlArtifactTicket.class;
    }

    @Generated
    public DefaultSamlArtifactTicketFactory(ExpirationPolicyBuilder<SamlArtifactTicket> expirationPolicyBuilder, OpenSamlConfigBean configBean, ServiceFactory<WebApplicationService> webApplicationServiceFactory, TicketTrackingPolicy descendantTicketsTrackingPolicy) {
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.configBean = configBean;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.descendantTicketsTrackingPolicy = descendantTicketsTrackingPolicy;
    }

    @Generated
    public ExpirationPolicyBuilder<SamlArtifactTicket> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }

    @Generated
    public UniqueTicketIdGenerator getTicketIdGenerator() {
        return this.ticketIdGenerator;
    }
}

