/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpClientFactory;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public final class HttpUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private static final Timeout CONNECT_TIMEOUT_IN_MILLISECONDS = HttpUtils.getTimeout("connectionTimeout");
    private static final Timeout SOCKET_TIMEOUT_IN_MILLISECONDS = HttpUtils.getTimeout("socketTimeout");
    private static final Timeout CONNECT_TTL_TIMEOUT_IN_MILLISECONDS = HttpUtils.getTimeout("connectionTimeToLive");
    private static final Timeout CONNECTION_REQUEST_TIMEOUT_IN_MILLISECONDS = HttpUtils.getTimeout("connectionRequest");

    private static Timeout getTimeout(String setting) {
        String timeoutValue = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty(HttpUtils.class.getName() + "." + setting), (CharSequence)"5000");
        return Timeout.ofMilliseconds((long)Long.parseLong(timeoutValue));
    }

    public static HttpResponse execute(HttpExecutionRequest execution) {
        URI uri = HttpUtils.buildHttpUri(execution.getUrl().trim(), execution.getParameters());
        HttpUriRequest request = HttpUtils.getHttpRequestByMethod(execution.getMethod().name().toLowerCase(Locale.ENGLISH).trim(), execution.getEntity(), uri);
        try {
            SpringExpressionLanguageValueResolver expressionResolver = SpringExpressionLanguageValueResolver.getInstance();
            execution.getHeaders().forEach((key, value) -> {
                String headerValue = expressionResolver.resolve((String)value);
                String headerKey = expressionResolver.resolve((String)key);
                request.addHeader(headerKey, (Object)headerValue);
            });
            HttpUtils.prepareHttpRequest(request, execution);
            CloseableHttpClient client = HttpUtils.getHttpClient(execution);
            return (HttpResponse)FunctionUtils.doAndRetry(retryContext -> {
                Integer maxAttempts;
                LOGGER.trace("Sending HTTP request to [{}]. Attempt: [{}]", (Object)request.getUri(), (Object)retryContext.getRetryCount());
                ClassicHttpResponse res = (ClassicHttpResponse)client.execute((ClassicHttpRequest)request, HttpRequestUtils.HTTP_CLIENT_RESPONSE_HANDLER);
                if (!(res != null && !HttpStatus.valueOf((int)res.getCode()).isError() || (maxAttempts = (Integer)retryContext.getAttribute("retry.maxAttempts")) != null && retryContext.getRetryCount() == maxAttempts - 1)) {
                    throw new HttpRequestExecutionException((HttpResponse)res);
                }
                return res;
            }, execution.getMaximumRetryAttempts());
        }
        catch (SSLHandshakeException e) {
            String sanitizedUrl = (String)FunctionUtils.doUnchecked(() -> new URIBuilder(execution.getUrl()).removeQuery().clearParameters().build().toASCIIString());
            LoggingUtils.error(LOGGER, "SSL error accessing: [" + sanitizedUrl + "]", e);
            return new BasicHttpResponse(500, sanitizedUrl);
        }
        catch (Exception e) {
            HttpRequestExecutionException hre;
            LoggingUtils.error(LOGGER, e);
            if (e instanceof HttpRequestExecutionException && (hre = (HttpRequestExecutionException)e).getResponse() != null) {
                BasicHttpResponse response = new BasicHttpResponse(hre.getResponse().getCode(), hre.getResponse().getReasonPhrase());
                response.setHeaders(hre.getResponse().getHeaders());
                return response;
            }
            return null;
        }
    }

    private static CloseableHttpClient getHttpClient(HttpExecutionRequest execution) throws Exception {
        HttpClientBuilder builder = HttpUtils.getHttpClientBuilder(execution);
        if (StringUtils.isNotBlank((CharSequence)execution.getProxyUrl())) {
            URL proxyEndpoint = new URI(execution.getProxyUrl()).toURL();
            HttpHost proxy = new HttpHost(proxyEndpoint.getHost(), proxyEndpoint.getPort());
            builder.setProxy(proxy);
        }
        return builder.build();
    }

    public static void close(HttpResponse response) {
        if (response instanceof CloseableHttpResponse) {
            CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)response;
            FunctionUtils.doAndHandle(__ -> closeableHttpResponse.close());
        }
    }

    public static HttpHeaders createBasicAuthHeaders(String basicAuthUser, String basicAuthPassword) {
        return HttpUtils.createBasicAuthHeaders(basicAuthUser, basicAuthPassword, "US-ASCII");
    }

    public static HttpHeaders createBasicAuthHeaders(String basicAuthUser, String basicAuthPassword, String basicCharset) {
        HttpHeaders acceptHeaders = new HttpHeaders();
        acceptHeaders.setAccept(CollectionUtils.wrap(MediaType.APPLICATION_JSON));
        if (StringUtils.isNotBlank((CharSequence)basicAuthUser) && StringUtils.isNotBlank((CharSequence)basicAuthPassword)) {
            String authorization = basicAuthUser + ":" + basicAuthPassword;
            String basic = EncodingUtils.encodeBase64(authorization.getBytes(Charset.forName(basicCharset)));
            acceptHeaders.set("Authorization", "Basic " + basic);
        }
        return acceptHeaders;
    }

    private static HttpUriRequest getHttpRequestByMethod(String method, String entity, URI uri) {
        if ("post".equalsIgnoreCase(method)) {
            HttpPost request = new HttpPost(uri);
            if (StringUtils.isNotBlank((CharSequence)entity)) {
                StringEntity stringEntity = new StringEntity(entity, StandardCharsets.UTF_8);
                request.setEntity((HttpEntity)stringEntity);
            }
            return request;
        }
        if ("patch".equalsIgnoreCase(method)) {
            HttpPatch request = new HttpPatch(uri);
            if (StringUtils.isNotBlank((CharSequence)entity)) {
                StringEntity stringEntity = new StringEntity(entity, StandardCharsets.UTF_8);
                request.setEntity((HttpEntity)stringEntity);
            }
            return request;
        }
        if ("delete".equalsIgnoreCase(method)) {
            return new HttpDelete(uri);
        }
        return new HttpGet(uri);
    }

    private static void prepareHttpRequest(HttpUriRequest request, HttpExecutionRequest execution) {
        if (execution.isBasicAuthentication()) {
            String auth = EncodingUtils.encodeBase64(execution.getBasicAuthUsername() + ":" + execution.getBasicAuthPassword());
            request.setHeader("Authorization", (Object)("Basic " + auth));
        }
        if (execution.isBearerAuthentication()) {
            request.setHeader("Authorization", (Object)("Bearer " + execution.getBearerToken()));
        }
    }

    private static URI buildHttpUri(String url, Map<String, String> parameters) {
        return (URI)FunctionUtils.doUnchecked(() -> {
            URIBuilder uriBuilder = new URIBuilder(url);
            parameters.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
            return uriBuilder.build();
        });
    }

    private static HttpClientBuilder getHttpClientBuilder(HttpExecutionRequest execution) {
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout(CONNECT_TIMEOUT_IN_MILLISECONDS);
        requestConfig.setConnectionRequestTimeout(CONNECTION_REQUEST_TIMEOUT_IN_MILLISECONDS);
        HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(requestConfig.build());
        if (execution.getMaximumRetryAttempts() <= 1) {
            builder.disableAutomaticRetries();
        }
        LayeredConnectionSocketFactory socketFactory = Optional.ofNullable(execution.getHttpClient()).map(HttpClient::httpClientFactory).filter(factory -> Objects.nonNull(factory.getSslSocketFactory())).map(HttpClientFactory::getSslSocketFactory).orElseGet(() -> HttpUtils.getSslConnectionSocketFactory(execution));
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(SOCKET_TIMEOUT_IN_MILLISECONDS).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setTimeToLive((TimeValue)CONNECT_TTL_TIMEOUT_IN_MILLISECONDS).setSocketTimeout(SOCKET_TIMEOUT_IN_MILLISECONDS).setConnectTimeout(CONNECT_TIMEOUT_IN_MILLISECONDS).build()).build();
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        return builder;
    }

    private static SSLConnectionSocketFactory getSslConnectionSocketFactory(HttpExecutionRequest execution) {
        SSLConnectionSocketFactoryBuilder builder = SSLConnectionSocketFactoryBuilder.create().useSystemProperties();
        Optional.ofNullable(execution.getHttpClient()).map(HttpClient::httpClientFactory).ifPresentOrElse(factory -> {
            builder.setHostnameVerifier(factory.getHostnameVerifier());
            builder.setSslContext(factory.getSslContext());
        }, () -> builder.setSslContext(SSLContexts.createDefault()).setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()));
        return builder.build();
    }

    @Generated
    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class HttpRequestExecutionException
    extends IllegalStateException {
        private static final long serialVersionUID = 3764678971716744728L;
        private final HttpResponse response;

        @Generated
        public HttpRequestExecutionException(HttpResponse response) {
            this.response = response;
        }

        @Generated
        public HttpResponse getResponse() {
            return this.response;
        }
    }
}

