/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;

class DtoProjectionTransformerDelegate {
    private final ReturnedType returnedType;
    private final Lazy<Boolean> applyRewriting;
    private final List<QueryTokenStream> selectItems = new ArrayList<QueryTokenStream>();

    public DtoProjectionTransformerDelegate(ReturnedType returnedType) {
        this.returnedType = returnedType;
        this.applyRewriting = Lazy.of(() -> returnedType.isDtoProjection() && returnedType.needsCustomConstruction());
    }

    public boolean applyRewriting() {
        return (Boolean)this.applyRewriting.get();
    }

    public boolean canRewrite() {
        return !this.selectItems.isEmpty() && this.applyRewriting();
    }

    public void appendSelectItem(QueryTokenStream selectItem) {
        if (this.applyRewriting()) {
            this.selectItems.add(new DetachedStream(selectItem));
        }
    }

    public QueryTokenStream getRewrittenSelectionList() {
        if (this.canRewrite()) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append(QueryTokens.TOKEN_NEW);
            builder.append(QueryTokens.token(this.returnedType.getReturnedType().getName()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (this.selectItems.size() == 1 && this.selectItems.get(0).size() == 1) {
                builder.appendInline(QueryTokenStream.concat(this.returnedType.getInputProperties(), property -> {
                    QueryRenderer.QueryRendererBuilder prop = QueryRenderer.builder();
                    prop.appendInline(this.selectItems.get(0));
                    prop.append(QueryTokens.TOKEN_DOT);
                    prop.append(QueryTokens.token(property));
                    return prop.build();
                }, QueryTokens.TOKEN_COMMA));
            } else {
                builder.append(QueryTokenStream.concat(this.selectItems, Function.identity(), QueryTokens.TOKEN_COMMA));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            return builder.build();
        }
        return QueryTokenStream.empty();
    }

    private static class DetachedStream
    extends QueryRenderer {
        private final QueryTokenStream delegate;

        private DetachedStream(QueryTokenStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isExpression() {
            return this.delegate.isExpression();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Iterator<QueryToken> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public String render() {
            return this.delegate instanceof QueryRenderer ? ((QueryRenderer)this.delegate).render() : this.delegate.toString();
        }
    }
}

