/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPLogoutProperties;
import org.apereo.cas.logout.slo.SingleLogoutUrl;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.idp.slo.SamlIdPProfileSingleLogoutRequestProcessor;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.sso.request.SSOSamlHttpRequestExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.ext.saml2mdreqinit.RequestInitiator;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Tag(name="SAML2")
public abstract class AbstractSamlSLOProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlSLOProfileHandlerController.class);

    protected AbstractSamlSLOProfileHandlerController(SamlProfileHandlerConfigurationContext context) {
        super(context);
    }

    private void handleLogoutResponse(Pair<? extends SignableSAMLObject, MessageContext> pair) {
        LogoutResponse logoutResponse = (LogoutResponse)pair.getKey();
        LOGGER.debug("Received logout response from [{}]", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)logoutResponse.getIssuer()));
        this.getConfigurationContext().getOpenSamlConfigBean().logObject((XMLObject)logoutResponse);
    }

    private void handleLogoutRequest(HttpServletResponse response, HttpServletRequest request, Pair<? extends SignableSAMLObject, MessageContext> pair, String logoutRequestBinding) throws Throwable {
        LogoutRequest logoutRequest = (LogoutRequest)pair.getKey();
        MessageContext messageContext = (MessageContext)pair.getValue();
        String entityId = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)logoutRequest);
        LOGGER.trace("SAML logout request from entity id [{}] is signed", (Object)entityId);
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(entityId);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new String[]{entityId}));
        SamlRegisteredService registeredService = (SamlRegisteredService)this.configurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).httpRequest((Object)request).httpResponse((Object)response).build();
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        LOGGER.trace("SAML registered service tied to [{}] is [{}]", (Object)entityId, (Object)registeredService);
        this.ensureLogoutRequestIsSignedIfNecessary(registeredService, messageContext);
        SamlRegisteredServiceMetadataAdaptor facade = (SamlRegisteredServiceMetadataAdaptor)SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId).orElseThrow();
        if (SAMLBindingSupport.isMessageSigned((MessageContext)messageContext)) {
            LOGGER.trace("Verifying signature on the SAML logout request for [{}]", (Object)entityId);
            this.configurationContext.getSamlObjectSignatureValidator().verifySamlProfileRequest((RequestAbstractType)logoutRequest, facade, request, messageContext);
        }
        this.configurationContext.getOpenSamlConfigBean().logObject((XMLObject)logoutRequest);
        List logoutUrls = SingleLogoutUrl.from((RegisteredService)registeredService);
        if (!logoutUrls.isEmpty()) {
            String destination = ((SingleLogoutUrl)logoutUrls.getFirst()).getUrl();
            WebUtils.putLogoutRedirectUrl((HttpServletRequest)request, (String)destination);
        }
        WebUtils.putRegisteredService((HttpServletRequest)request, (RegisteredService)registeredService);
        Extensions extensions = this.buildSamlObject(Extensions.DEFAULT_ELEMENT_NAME, Extensions.class);
        RequestInitiator bindingAttribute = this.buildSamlObject(RequestInitiator.DEFAULT_ELEMENT_NAME, RequestInitiator.class);
        bindingAttribute.setBinding(logoutRequestBinding);
        extensions.getUnknownXMLObjects().add(bindingAttribute);
        logoutRequest.setExtensions(extensions);
        try (StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (XMLObject)logoutRequest);){
            String encodedRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
            WebUtils.putSingleLogoutRequest((HttpServletRequest)request, (String)encodedRequest);
        }
        this.configurationContext.getApplicationContext().getBeansOfType(SamlIdPProfileSingleLogoutRequestProcessor.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<SamlIdPProfileSingleLogoutRequestProcessor>)AnnotationAwareOrderComparator.INSTANCE).filter(processor -> processor.supports(request, response, logoutRequest, messageContext)).forEach(Unchecked.consumer(processor -> processor.receive(request, response, logoutRequest, messageContext)));
        RequestDispatcher requestDispatcher = request.getServletContext().getRequestDispatcher("/logout");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void ensureLogoutRequestIsSignedIfNecessary(SamlRegisteredService registeredService, MessageContext messageContext) throws SAMLException {
        boolean ensureSignature = false;
        if (registeredService.getSignLogoutRequest().isUndefined()) {
            SamlIdPLogoutProperties logout = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getLogout();
            ensureSignature = logout.isForceSignedLogoutRequests();
        } else {
            ensureSignature = registeredService.getSignLogoutRequest().isTrue();
        }
        if (ensureSignature && !SAMLBindingSupport.isMessageSigned((MessageContext)messageContext)) {
            throw new SAMLException("Logout request is not signed but should be for service %s".formatted(registeredService.getServiceId()));
        }
    }

    protected <T> T buildSamlObject(QName qname, Class<T> clazz) {
        XMLObjectBuilderFactory builderFactory = this.getConfigurationContext().getOpenSamlConfigBean().getBuilderFactory();
        SAMLObjectBuilder builder = (SAMLObjectBuilder)builderFactory.getBuilder(qname);
        return clazz.cast(Objects.requireNonNull(builder).buildObject());
    }

    protected void handleSloProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder, String logoutRequestBinding) throws Throwable {
        SamlIdPLogoutProperties logout = this.getConfigurationContext().getCasProperties().getAuthn().getSamlIdp().getLogout();
        if (logout.isSingleLogoutCallbacksDisabled()) {
            LOGGER.info("Processing SAML2 IdP SLO requests is disabled");
            return;
        }
        SSOSamlHttpRequestExtractor extractor = this.getConfigurationContext().getSamlHttpRequestExtractor();
        Optional<Pair<? extends SignableSAMLObject, MessageContext>> result = extractor.extract(request, decoder, SignableSAMLObject.class);
        if (result.isPresent()) {
            Pair<? extends SignableSAMLObject, MessageContext> pair = result.get();
            if (pair.getKey() instanceof LogoutResponse) {
                this.handleLogoutResponse(pair);
            } else if (pair.getKey() instanceof LogoutRequest) {
                this.handleLogoutRequest(response, request, pair, logoutRequestBinding);
            }
        } else {
            LOGGER.trace("Unable to process logout request/response");
        }
    }
}

