/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.model.EventModelBuilder;
import org.flowable.eventregistry.impl.EventRepositoryServiceImpl;
import org.flowable.eventregistry.json.converter.EventJsonConverter;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;

public class EventModelBuilderImpl
implements EventModelBuilder {
    protected EventRepositoryServiceImpl eventRepository;
    protected EventJsonConverter eventJsonConverter;
    protected String deploymentName;
    protected String resourceName;
    protected String category;
    protected String parentDeploymentId;
    protected String deploymentTenantId;
    protected String key;
    protected Map<String, EventPayload> eventPayloadDefinitions = new LinkedHashMap<String, EventPayload>();

    public EventModelBuilderImpl(EventRepositoryServiceImpl eventRepository, EventJsonConverter eventJsonConverter) {
        this.eventRepository = eventRepository;
        this.eventJsonConverter = eventJsonConverter;
    }

    public EventModelBuilder key(String key) {
        this.key = key;
        return this;
    }

    public EventModelBuilder deploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public EventModelBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public EventModelBuilder category(String category) {
        this.category = category;
        return this;
    }

    public EventModelBuilder parentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public EventModelBuilder deploymentTenantId(String deploymentTenantId) {
        this.deploymentTenantId = deploymentTenantId;
        return this;
    }

    public EventModelBuilder header(String name, String type) {
        this.eventPayloadDefinitions.put(name, EventPayload.header((String)name, (String)type));
        return this;
    }

    public EventModelBuilder headerWithCorrelation(String name, String type) {
        this.eventPayloadDefinitions.put(name, EventPayload.headerWithCorrelation((String)name, (String)type));
        return this;
    }

    public EventModelBuilder correlationParameter(String name, String type) {
        this.eventPayloadDefinitions.put(name, EventPayload.correlation((String)name, (String)type));
        return this;
    }

    public EventModelBuilder payload(String name, String type) {
        this.eventPayloadDefinitions.put(name, new EventPayload(name, type));
        return this;
    }

    public EventModelBuilder metaParameter(String name, String type) {
        EventPayload payload = new EventPayload(name, type);
        payload.setMetaParameter(true);
        this.eventPayloadDefinitions.put(name, payload);
        return this;
    }

    public EventModelBuilder fullPayload(String name) {
        this.eventPayloadDefinitions.put(name, EventPayload.fullPayload((String)name));
        return this;
    }

    public EventModel createEventModel() {
        return this.buildEventModel();
    }

    public EventDeployment deploy() {
        if (this.resourceName == null) {
            throw new FlowableIllegalArgumentException("A resource name is mandatory");
        }
        EventModel eventModel = this.buildEventModel();
        return this.eventRepository.createDeployment().name(this.deploymentName).addEventDefinition(this.resourceName, this.eventJsonConverter.convertToJson(eventModel)).category(this.category).parentDeploymentId(this.parentDeploymentId).tenantId(this.deploymentTenantId).deploy();
    }

    protected EventModel buildEventModel() {
        EventModel eventModel = new EventModel();
        if (!StringUtils.isNotEmpty((CharSequence)this.key)) {
            throw new FlowableIllegalArgumentException("An event definition key is mandatory");
        }
        eventModel.setKey(this.key);
        eventModel.setPayload(this.eventPayloadDefinitions.values());
        return eventModel;
    }
}

