/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.discovery;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.discovery.webfinger.OidcWebFingerDiscoveryService;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="OpenID Connect")
public class OidcWellKnownEndpointController
extends BaseOidcController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcWellKnownEndpointController.class);
    private final OidcWebFingerDiscoveryService webFingerDiscoveryService;

    public OidcWellKnownEndpointController(OidcConfigurationContext configurationContext, OidcWebFingerDiscoveryService webFingerDiscoveryService) {
        super(configurationContext);
        this.webFingerDiscoveryService = webFingerDiscoveryService;
    }

    @GetMapping(value={"/oidc/.well-known", "/**/.well-known"}, produces={"application/json"})
    @Operation(summary="Handle OIDC discovery request", description="Handles requests for well-known OIDC discovery configuration")
    public ResponseEntity<OidcServerDiscoverySettings> getWellKnownDiscoveryConfiguration(HttpServletRequest request, HttpServletResponse response) {
        return this.getOidcServerDiscoveryResponse(request, response, List.of(".well-known"));
    }

    @GetMapping(value={"/oidc/.well-known/openid-configuration", "/oidc/.well-known/oauth-authorization-server", "/**/.well-known/openid-configuration"}, produces={"application/json"})
    @Operation(summary="Handle OIDC discovery request", description="Handles requests for well-known OIDC discovery configuration")
    public ResponseEntity<OidcServerDiscoverySettings> getWellKnownOpenIdDiscoveryConfiguration(HttpServletRequest request, HttpServletResponse response) {
        return this.getOidcServerDiscoveryResponse(request, response, List.of(".well-known/openid-configuration"));
    }

    @GetMapping(value={"/oidc/.well-known/webfinger"}, produces={"application/jrd+json"})
    @Operation(summary="Handle webfinger discovery request")
    public ResponseEntity<Map> getWebFingerResponse(@RequestParam(value="resource") String resource, @RequestParam(value="rel", required=false) String rel) throws Throwable {
        return BeanSupplier.isNotProxy((Object)this.webFingerDiscoveryService) ? this.webFingerDiscoveryService.handleRequest(resource, rel) : ResponseEntity.notFound().build();
    }

    private ResponseEntity<OidcServerDiscoverySettings> getOidcServerDiscoveryResponse(HttpServletRequest request, HttpServletResponse response, List<String> endpoints) {
        if (this.isIssuerValidForEndpoint(request, response, endpoints) && BeanSupplier.isNotProxy((Object)this.webFingerDiscoveryService)) {
            OidcServerDiscoverySettings discovery = this.webFingerDiscoveryService.getDiscovery();
            return new ResponseEntity((Object)discovery, (HttpStatusCode)HttpStatus.OK);
        }
        LOGGER.warn("Unable to accept request; issuer for endpoint(s) [{}] is invalid", endpoints);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

