/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.util.List;
import java.util.Optional;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenExchangeGrantTypeTokenRequestValidator;
import org.jose4j.jwt.JwtClaims;
import org.springframework.beans.factory.ObjectProvider;

public class OidcTokenExchangeGrantTypeTokenRequestValidator
extends OAuth20TokenExchangeGrantTypeTokenRequestValidator<OidcConfigurationContext> {
    public OidcTokenExchangeGrantTypeTokenRequestValidator(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    protected OAuthRegisteredService extractRegisteredService(String subjectTokenType, String subjectToken) throws Exception {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.getConfigurationContext().getObject());
        if (configurationContext.getDiscoverySettings().isNativeSsoSupported() && OAuth20TokenExchangeTypes.from((String)subjectTokenType) == OAuth20TokenExchangeTypes.ID_TOKEN) {
            String clientIdInIdToken = OAuth20Utils.extractClientIdFromToken((String)subjectToken);
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)clientIdInIdToken);
            JwtClaims claims = configurationContext.getIdTokenSigningAndEncryptionService().decode(subjectToken, Optional.ofNullable(registeredService));
            WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(claims.getIssuer());
            service.getAttributes().put("client_id", List.of(clientIdInIdToken));
            return OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)clientIdInIdToken);
        }
        return super.extractRegisteredService(subjectTokenType, subjectToken);
    }
}

