/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.federation;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsSet;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.federation.OidcFederationJsonWebKeystoreService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;

public class OidcFederationDefaultJsonWebKeystoreService
implements OidcFederationJsonWebKeystoreService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcFederationDefaultJsonWebKeystoreService.class);
    private JsonWebKey jsonWebKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OidcFederationDefaultJsonWebKeystoreService(OidcProperties oidcProperties) throws Exception {
        String jwksFile = SpringExpressionLanguageValueResolver.getInstance().resolve(oidcProperties.getFederation().getJwksFile());
        AbstractResource resource = ResourceUtils.getRawResourceFrom((String)jwksFile);
        try {
            if (ResourceUtils.doesResourceExist((String)jwksFile)) {
                LOGGER.debug("Loading OpenID Connect Federation JSON web key from [{}]", (Object)resource);
                String jwks = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                List jsonWebKeys = new JsonWebKeySet(jwks).getJsonWebKeys();
                if (!jsonWebKeys.isEmpty()) {
                    this.jsonWebKey = (JsonWebKey)jsonWebKeys.getFirst();
                    LOGGER.debug("Loaded OpenID Connect Federation JSON web key from [{}]", (Object)this.jsonWebKey.getKeyId());
                }
            }
            if (this.jsonWebKey != null) return;
        }
        catch (Exception e) {
            try {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                if (this.jsonWebKey != null) return;
            }
            catch (Throwable throwable) {
                if (this.jsonWebKey != null) throw throwable;
                LOGGER.debug("JSON web key for OpenID Connect Federation is not found. Generating a new one");
                this.jsonWebKey = OidcJsonWebKeyStoreUtils.generateJsonWebKey(oidcProperties.getJwks().getCore().getJwksType(), oidcProperties.getJwks().getCore().getJwksKeySize(), OidcJsonWebKeyUsage.SIGNING);
                if (ResourceUtils.doesResourceExist((String)jwksFile)) throw throwable;
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{this.jsonWebKey});
                String json = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
                LOGGER.debug("Writing OpenID Connect Federation JSON web key to [{}]", (Object)resource);
                FileUtils.write((File)resource.getFile(), (CharSequence)json, (Charset)StandardCharsets.UTF_8);
                throw throwable;
            }
            LOGGER.debug("JSON web key for OpenID Connect Federation is not found. Generating a new one");
            this.jsonWebKey = OidcJsonWebKeyStoreUtils.generateJsonWebKey(oidcProperties.getJwks().getCore().getJwksType(), oidcProperties.getJwks().getCore().getJwksKeySize(), OidcJsonWebKeyUsage.SIGNING);
            if (ResourceUtils.doesResourceExist((String)jwksFile)) return;
            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{this.jsonWebKey});
            String json = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
            LOGGER.debug("Writing OpenID Connect Federation JSON web key to [{}]", (Object)resource);
            FileUtils.write((File)resource.getFile(), (CharSequence)json, (Charset)StandardCharsets.UTF_8);
            return;
        }
        LOGGER.debug("JSON web key for OpenID Connect Federation is not found. Generating a new one");
        this.jsonWebKey = OidcJsonWebKeyStoreUtils.generateJsonWebKey(oidcProperties.getJwks().getCore().getJwksType(), oidcProperties.getJwks().getCore().getJwksKeySize(), OidcJsonWebKeyUsage.SIGNING);
        if (ResourceUtils.doesResourceExist((String)jwksFile)) return;
        JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(new JsonWebKey[]{this.jsonWebKey});
        String json = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        LOGGER.debug("Writing OpenID Connect Federation JSON web key to [{}]", (Object)resource);
        FileUtils.write((File)resource.getFile(), (CharSequence)json, (Charset)StandardCharsets.UTF_8);
        return;
    }

    @Override
    public JWKSet toJWKSet() throws Exception {
        JWK jwk = JWK.parse((String)this.jsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
        return new JWKSet(jwk.toPublicJWK());
    }

    @Override
    public EntityStatement signEntityStatement(EntityStatementClaimsSet claims) throws Exception {
        JWK jwk = JWK.parse((String)this.jsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
        return EntityStatement.sign((EntityStatementClaimsSet)claims, (JWK)jwk);
    }
}

