/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.listener.CasAuthenticationAuthenticationEventListener;
import org.apereo.cas.support.events.listener.CasAuthenticationEventListener;
import org.apereo.cas.support.events.web.CasEventsReportEndpoint;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.text.MessageSanitizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Events})
@AutoConfiguration
public class CasCoreEventsAutoConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.events.core.enabled").isTrue().evenIfMissing();

    @Configuration(value="CasCoreEventsRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreEventsRepositoryConfiguration {
        CasCoreEventsRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casEventRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasEventRepository casEventRepository(ConfigurableApplicationContext applicationContext) {
            return (CasEventRepository)BeanSupplier.of(CasEventRepository.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(CasEventRepository::noOp).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"transactionManagerEvents"})
        public PlatformTransactionManager transactionManagerEvents() {
            return new PseudoTransactionManager();
        }
    }

    @Configuration(value="CasCoreEventsWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreEventsWebConfiguration {
        CasCoreEventsWebConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasEventsReportEndpoint casEventsReportEndpoint(@Qualifier(value="casEventRepository") ObjectProvider<CasEventRepository> casEventRepository, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new CasEventsReportEndpoint(casProperties, applicationContext, casEventRepository);
        }
    }

    @Configuration(value="CasCoreEventsListenerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreEventsListenerConfiguration {
        CasCoreEventsListenerConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultCasEventListener"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public CasAuthenticationEventListener defaultCasEventListener(@Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, @Qualifier(value="messageSanitizer") MessageSanitizer messageSanitizer, ConfigurableApplicationContext applicationContext, @Qualifier(value="casEventRepository") CasEventRepository casEventRepository, @Qualifier(value="logoutManager") LogoutManager logoutManager) {
            return (CasAuthenticationEventListener)BeanSupplier.of(CasAuthenticationEventListener.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new CasAuthenticationAuthenticationEventListener(casEventRepository, messageSanitizer, (GeoLocationService)geoLocationService.getIfAvailable(), logoutManager)).otherwiseProxy().get();
        }
    }
}

