/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.client;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface DelegatedClientNameExtractor {
    public static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientNameExtractor.class);

    public Optional<String> extract(HttpServletRequest var1);

    default public Optional<String> extract(WebContext context) {
        return this.extract(((JEEContext)context).getNativeRequest());
    }

    public static DelegatedClientNameExtractor fromHttpRequest() {
        return context -> {
            String clientName = context.getParameter("client_name");
            String relayState = context.getParameter("RelayState");
            if (StringUtils.isBlank((CharSequence)clientName) && StringUtils.isNotBlank((CharSequence)relayState) && Strings.CI.startsWith((CharSequence)relayState, (CharSequence)"http")) {
                clientName = DelegatedClientNameExtractor.extractClientNameFromRelayStateUrl(relayState);
            }
            return Optional.ofNullable(clientName);
        };
    }

    private static String extractClientNameFromRelayStateUrl(String relayState) {
        return (String)FunctionUtils.doAndHandle(() -> {
            URIBuilder uriBuilder = new URIBuilder(relayState);
            NameValuePair relayStateParam = uriBuilder.getFirstQueryParam("client_name");
            return relayStateParam != null ? relayStateParam.getValue() : null;
        });
    }
}

