/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.attribute.AttributeDefinition;
import org.apereo.cas.authentication.attribute.AttributeDefinitionResolutionContext;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class DefaultAttributeDefinitionStore
implements AttributeDefinitionStore,
DisposableBean,
AutoCloseable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAttributeDefinitionStore.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final Map<String, AttributeDefinition> attributeDefinitions = Collections.synchronizedMap(new ConcurrentHashMap());
    private FileWatcherService storeWatcherService;
    private String scope = "";

    public DefaultAttributeDefinitionStore(Resource resource) throws Exception {
        if (ResourceUtils.doesResourceExist((Resource)resource)) {
            this.importStore(resource);
            this.watchStore(resource);
        }
    }

    public DefaultAttributeDefinitionStore(AttributeDefinition ... definitions) {
        Arrays.stream(definitions).forEach(this::registerAttributeDefinition);
    }

    public void registerAttributeDefinitions(Map<String, AttributeDefinition> entries) {
        entries.forEach(this::registerAttributeDefinition);
    }

    private static String getAttributeDefinitionKey(String key, AttributeDefinition definition) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)definition.getKey()) && !Strings.CI.equals(definition.getKey(), key)) {
            LOGGER.warn("Attribute definition contains a key property [{}] that differs from its registering key [{}]. This is likely due to misconfiguration of the attribute definition, and CAS will use the key property [{}] to register the attribute definition in the attribute store", new Object[]{definition.getKey(), key, definition.getKey()});
            return definition.getKey();
        }
        return key;
    }

    @CanIgnoreReturnValue
    public AttributeDefinitionStore registerAttributeDefinition(AttributeDefinition definition) {
        return this.registerAttributeDefinition(definition.getKey(), definition);
    }

    @CanIgnoreReturnValue
    public AttributeDefinitionStore registerAttributeDefinition(String key, AttributeDefinition definition) {
        LOGGER.trace("Registering attribute definition [{}] by key [{}]", (Object)definition, (Object)key);
        String keyToUse = DefaultAttributeDefinitionStore.getAttributeDefinitionKey(key, definition);
        this.attributeDefinitions.put(keyToUse, definition);
        return this;
    }

    @CanIgnoreReturnValue
    public AttributeDefinitionStore removeAttributeDefinition(String key) {
        LOGGER.debug("Removing attribute definition by key [{}]", (Object)key);
        if (this.attributeDefinitions.containsKey(key)) {
            AttributeDefinition definition = this.attributeDefinitions.remove(key);
            LOGGER.debug("Attribute definition [{}] has been removed from the definition store", (Object)definition);
        } else {
            LOGGER.debug("Attribute definition with the registered key [{}] was not found and the store was not altered", (Object)key);
        }
        return this;
    }

    public Optional<AttributeDefinition> locateAttributeDefinitionByName(String name) {
        return this.attributeDefinitions.values().stream().filter(entry -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entry.getName())).filter(entry -> entry.getName().equalsIgnoreCase(name)).findFirst();
    }

    public Optional<AttributeDefinition> locateAttributeDefinition(String key) {
        LOGGER.trace("Locating attribute definition for [{}]", (Object)key);
        return Optional.ofNullable(this.attributeDefinitions.get(key));
    }

    public <T extends AttributeDefinition> Optional<T> locateAttributeDefinition(String key, Class<T> clazz) {
        LOGGER.trace("Locating attribute definition for [{}]", (Object)key);
        AttributeDefinition attributeDefinition = this.attributeDefinitions.get(key);
        if (attributeDefinition != null && clazz.isAssignableFrom(attributeDefinition.getClass())) {
            return Optional.of(attributeDefinition);
        }
        return Optional.empty();
    }

    public <T extends AttributeDefinition> Optional<T> locateAttributeDefinition(Predicate<AttributeDefinition> predicate) {
        return this.attributeDefinitions.values().stream().filter(predicate).map(definition -> definition).findFirst();
    }

    public Collection<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions.values();
    }

    public <T extends AttributeDefinition> Stream<T> getAttributeDefinitionsBy(Class<T> type) {
        return this.attributeDefinitions.values().stream().filter(definition -> type.isAssignableFrom(definition.getClass())).map(type::cast);
    }

    public Map<String, List<Object>> resolveAttributeValues(Collection<String> attributeDefinitions, Map<String, List<Object>> availableAttributes, Principal principal, RegisteredService registeredService, Service service) {
        LinkedHashMap<String, List<Object>> finalAttributes = new LinkedHashMap<String, List<Object>>(attributeDefinitions.size());
        attributeDefinitions.forEach(entry -> this.locateAttributeDefinition((String)entry).ifPresentOrElse(definition -> {
            List<Object> attributeValues = DefaultAttributeDefinitionStore.determineValuesForAttributeDefinition(availableAttributes, entry, definition);
            LOGGER.trace("Resolving attribute [{}] from attribute definition store with values [{}]", entry, attributeValues);
            AttributeDefinitionResolutionContext attributeDefinitionResolutionContext = AttributeDefinitionResolutionContext.builder().attributeValues(attributeValues).principal(principal).registeredService(registeredService).service(service).attributes(availableAttributes).scope(this.scope).build();
            Optional<Pair<AttributeDefinition, List<Object>>> result = this.resolveAttributeValues((String)entry, attributeDefinitionResolutionContext);
            if (result.isPresent()) {
                List resolvedValues = (List)result.get().getValue();
                if (resolvedValues.isEmpty()) {
                    LOGGER.debug("Unable to produce or determine attributes values for attribute definition [{}]", definition);
                } else {
                    LOGGER.trace("Resolving attribute [{}] based on attribute definition [{}]", entry, definition);
                    Set attributeKeys = StringUtils.commaDelimitedListToSet((String)((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)definition.getName(), (CharSequence)entry)));
                    attributeKeys.forEach(key -> {
                        LOGGER.trace("Determined attribute name to be [{}] with values [{}]", key, (Object)resolvedValues);
                        finalAttributes.put((String)key, resolvedValues);
                    });
                }
            }
        }, () -> {
            if (availableAttributes.containsKey(entry)) {
                LOGGER.trace("Using already-resolved attribute name/value, as no attribute definition was found for [{}]", entry);
                finalAttributes.put((String)entry, (List)availableAttributes.get(entry));
            }
        }));
        LOGGER.trace("Final collection of attributes resolved from attribute definition store is [{}]", finalAttributes);
        return finalAttributes;
    }

    public Optional<Pair<AttributeDefinition, List<Object>>> resolveAttributeValues(String key, AttributeDefinitionResolutionContext context) {
        Optional<AttributeDefinition> result = this.locateAttributeDefinition(key);
        return result.flatMap(definition -> (Optional)FunctionUtils.doUnchecked(() -> {
            List currentValues = definition.resolveAttributeValues(context.withScope(this.scope));
            return Optional.of(Pair.of((Object)definition, (Object)currentValues));
        }));
    }

    public boolean isEmpty() {
        return this.attributeDefinitions.isEmpty();
    }

    @CanIgnoreReturnValue
    public AttributeDefinitionStore store(Resource resource) {
        return (AttributeDefinitionStore)FunctionUtils.doUnchecked(() -> {
            String json = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(this.attributeDefinitions);
            LOGGER.trace("Storing attribute definitions as [{}] to [{}]", (Object)json, (Object)resource);
            try (BufferedWriter writer = Files.newBufferedWriter(resource.getFile().toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(json);
                writer.flush();
            }
            return this;
        });
    }

    public void importStore(Resource resource) {
        try {
            Map<String, AttributeDefinition> map = DefaultAttributeDefinitionStore.from(resource);
            map.forEach(this::registerAttributeDefinition);
        }
        finally {
            LOGGER.debug("Loaded [{}] attribute definition(s).", (Object)this.attributeDefinitions.size());
        }
    }

    @Override
    public void close() {
        if (this.storeWatcherService != null) {
            this.storeWatcherService.close();
        }
    }

    public void destroy() {
        this.close();
    }

    private static List<Object> determineValuesForAttributeDefinition(Map<String, List<Object>> attributes, String entry, AttributeDefinition definition) {
        String attributeKey = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)definition.getAttribute(), (CharSequence)entry);
        if (attributes.containsKey(attributeKey)) {
            return attributes.get(attributeKey);
        }
        return new ArrayList<Object>();
    }

    public void watchStore(Resource resource) throws Exception {
        if (ResourceUtils.isFile((Resource)resource)) {
            this.storeWatcherService = new FileWatcherService(resource.getFile(), file -> this.importStore((Resource)new FileSystemResource(file)));
            this.storeWatcherService.start(this.getClass().getSimpleName());
        }
    }

    public static Map<String, AttributeDefinition> from(Resource resource) {
        return (Map)FunctionUtils.doIfNotNull((Object)resource, () -> {
            try (InputStream is = resource.getInputStream();){
                LOGGER.trace("Loading attribute definitions from [{}]", (Object)resource);
                String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                LOGGER.trace("Loaded attribute definitions [{}] from [{}]", (Object)json, (Object)resource);
                Map map = (Map)MAPPER.readValue(JsonValue.readHjson((String)json).toString(), (TypeReference)new TypeReference<Map<String, AttributeDefinition>>(){});
                return map;
            }
        }, Map::of).get();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAttributeDefinitionStore)) {
            return false;
        }
        DefaultAttributeDefinitionStore other = (DefaultAttributeDefinitionStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, AttributeDefinition> this$attributeDefinitions = this.attributeDefinitions;
        Map<String, AttributeDefinition> other$attributeDefinitions = other.attributeDefinitions;
        return !(this$attributeDefinitions == null ? other$attributeDefinitions != null : !((Object)this$attributeDefinitions).equals(other$attributeDefinitions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultAttributeDefinitionStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, AttributeDefinition> $attributeDefinitions = this.attributeDefinitions;
        result = result * 59 + ($attributeDefinitions == null ? 43 : ((Object)$attributeDefinitions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DefaultAttributeDefinitionStore(attributeDefinitions=" + String.valueOf(this.attributeDefinitions) + ")";
    }

    @Generated
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Generated
    public String getScope() {
        return this.scope;
    }
}

