/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.nativesso.DefaultOidcDeviceSecretGenerator;
import org.apereo.cas.oidc.nativesso.OidcDeviceSecretGenerator;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestValidator;
import org.apereo.cas.oidc.token.OidcAccessTokenTokenExchangeGrantRequestExtractor;
import org.apereo.cas.oidc.token.OidcIdTokenExpirationPolicyBuilder;
import org.apereo.cas.oidc.token.OidcIdTokenGeneratorService;
import org.apereo.cas.oidc.token.OidcTokenExchangeGrantTypeTokenRequestValidator;
import org.apereo.cas.oidc.token.ciba.AccessTokenCibaGrantRequestExtractor;
import org.apereo.cas.oidc.token.ciba.CibaPingTokenDeliveryHandler;
import org.apereo.cas.oidc.token.ciba.CibaPollTokenDeliveryHandler;
import org.apereo.cas.oidc.token.ciba.CibaPushTokenDeliveryHandler;
import org.apereo.cas.oidc.token.ciba.CibaTokenDeliveryHandler;
import org.apereo.cas.oidc.token.ciba.OidcAccessTokenCibaGrantRequestValidator;
import org.apereo.cas.oidc.web.OidcAccessTokenResponseGenerator;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcImplicitIdTokenAuthorizationResponseBuilder;
import org.apereo.cas.oidc.web.OidcPushedAuthorizationModelAndViewBuilder;
import org.apereo.cas.oidc.web.OidcPushedAuthorizationRequestUriResponseBuilder;
import org.apereo.cas.oidc.web.response.OidcIntrospectionResponseGenerator;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.validator.authorization.OAuth20AuthorizationRequestValidator;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenGrantRequestExtractor;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationCodeAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ClientCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResourceOwnerCredentialsResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20TokenAuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionResponseGenerator;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.idtoken.IdTokenGeneratorService;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
@Configuration(value="OidcResponseConfiguration", proxyBeanMethods=false)
class OidcResponseConfiguration {
    OidcResponseConfiguration() {
    }

    @Configuration(value="OidcResponseTokenGenerationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseTokenGenerationConfiguration {
        OidcResponseTokenGenerationConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcIntrospectionResponseGenerator"})
        @Bean
        public OAuth20IntrospectionResponseGenerator oidcIntrospectionResponseGenerator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcIntrospectionResponseGenerator(oidcConfigurationContext);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcIdTokenGenerator"})
        @Bean
        public IdTokenGeneratorService oidcIdTokenGenerator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcIdTokenGeneratorService(oidcConfigurationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcDeviceSecretGenerator"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OidcDeviceSecretGenerator oidcDeviceSecretGenerator() {
            return new DefaultOidcDeviceSecretGenerator();
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcIdTokenExpirationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder oidcIdTokenExpirationPolicy(CasConfigurationProperties casProperties) {
            return new OidcIdTokenExpirationPolicyBuilder(casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcCibaPushTokenDeliveryHandler"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CibaTokenDeliveryHandler oidcCibaPushTokenDeliveryHandler(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new CibaPushTokenDeliveryHandler(oidcConfigurationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcCibaPingTokenDeliveryHandler"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CibaTokenDeliveryHandler oidcCibaPingTokenDeliveryHandler(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new CibaPingTokenDeliveryHandler(oidcConfigurationContext);
        }

        @Bean
        @ConditionalOnMissingBean(name={"oidcCibaPollTokenDeliveryHandler"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CibaTokenDeliveryHandler oidcCibaPollTokenDeliveryHandler(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new CibaPollTokenDeliveryHandler(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcCibaAccessTokenGrantRequestExtractor"})
        public AccessTokenGrantRequestExtractor oidcCibaAccessTokenGrantRequestExtractor(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> context) {
            return new AccessTokenCibaGrantRequestExtractor(context);
        }
    }

    @Configuration(value="OidcResponseResourceOwnerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseResourceOwnerConfiguration {
        OidcResponseResourceOwnerConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcResourceOwnerCredentialsResponseBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcResourceOwnerCredentialsResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OAuth20ResourceOwnerCredentialsResponseBuilder((OAuth20ConfigurationContext)oidcConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }
    }

    @Configuration(value="OidcResponseImplicitConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseImplicitConfiguration {
        OidcResponseImplicitConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcImplicitIdTokenCallbackUrlBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenCallbackUrlBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcImplicitIdTokenAuthorizationResponseBuilder(oidcConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcImplicitIdTokenAndTokenCallbackUrlBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcImplicitIdTokenAndTokenCallbackUrlBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcImplicitIdTokenAndTokenAuthorizationResponseBuilder(oidcConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }
    }

    @Configuration(value="OidcResponseAuthorizationCodeConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseAuthorizationCodeConfiguration {
        OidcResponseAuthorizationCodeConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcAuthorizationCodeResponseBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcAuthorizationCodeResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OAuth20AuthorizationCodeAuthorizationResponseBuilder((OAuth20ConfigurationContext)oidcConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationModelAndViewBuilder"})
        public OAuth20AuthorizationModelAndViewBuilder oidcPushedAuthorizationModelAndViewBuilder() {
            return new OidcPushedAuthorizationModelAndViewBuilder();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationRequestResponseBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcPushedAuthorizationRequestResponseBuilder(@Qualifier(value="oidcPushedAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oidcPushedAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OidcPushedAuthorizationRequestUriResponseBuilder(oidcConfigurationContext, oidcPushedAuthorizationModelAndViewBuilder);
        }

        @ConditionalOnMissingBean(name={"oidcPushedAuthorizationRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AuthorizationRequestValidator oidcPushedAuthorizationRequestValidator(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="oauthRequestParameterResolver") OAuth20RequestParameterResolver oauthRequestParameterResolver, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new OidcPushedAuthorizationRequestValidator(servicesManager, webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, ticketFactory, oauthRequestParameterResolver);
        }

        @ConditionalOnMissingBean(name={"oidcAccessTokenCibaGrantRequestValidator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oidcAccessTokenCibaGrantRequestValidator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcAccessTokenCibaGrantRequestValidator(oidcConfigurationContext);
        }
    }

    @Configuration(value="OidcResponseTokenConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseTokenConfiguration {
        OidcResponseTokenConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcTokenResponseBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcTokenResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OAuth20TokenAuthorizationResponseBuilder((OAuth20ConfigurationContext)oidcConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }
    }

    @Configuration(value="OidcResponseClientCredentialConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseClientCredentialConfiguration {
        OidcResponseClientCredentialConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"oidcClientCredentialsResponseBuilder"})
        public OAuth20AuthorizationResponseBuilder oidcClientCredentialsResponseBuilder(@Qualifier(value="oauthAuthorizationModelAndViewBuilder") OAuth20AuthorizationModelAndViewBuilder oauthAuthorizationModelAndViewBuilder, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
            return new OAuth20ClientCredentialsResponseBuilder((OAuth20ConfigurationContext)oidcConfigurationContext, oauthAuthorizationModelAndViewBuilder);
        }
    }

    @Configuration(value="OidcResponseAccessTokenConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class OidcResponseAccessTokenConfiguration {
        OidcResponseAccessTokenConfiguration() {
        }

        @ConditionalOnMissingBean(name={"oidcAccessTokenResponseGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20AccessTokenResponseGenerator oidcAccessTokenResponseGenerator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcAccessTokenResponseGenerator(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AccessTokenGrantRequestExtractor accessTokenTokenExchangeGrantRequestExtractor(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcAccessTokenTokenExchangeGrantRequestExtractor(oidcConfigurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public OAuth20TokenRequestValidator oauthTokenExchangeGrantTypeTokenRequestValidator(@Qualifier(value="oidcConfigurationContext") ObjectProvider<OidcConfigurationContext> oidcConfigurationContext) {
            return new OidcTokenExchangeGrantTypeTokenRequestValidator(oidcConfigurationContext);
        }
    }
}

