/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.CentralAuthenticationServiceContext;
import org.apereo.cas.DefaultCentralAuthenticationService;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.AuthenticationPolicyExecutionResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategyConfigurer;
import org.apereo.cas.authentication.DefaultAuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.DefaultServiceMatchingStrategy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceMatchingStrategy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.lock.LockRepository;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableTransactionManagement(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Core})
@Configuration(value="CasCoreConfiguration", proxyBeanMethods=false)
class CasCoreConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreConfiguration.class);

    CasCoreConfiguration() {
    }

    @Configuration(value="CasCoreContextConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreContextConfiguration {
        CasCoreContextConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"centralAuthenticationService"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CentralAuthenticationService centralAuthenticationService(@Qualifier(value="centralAuthenticationServiceContext") CentralAuthenticationServiceContext centralAuthenticationServiceContext) {
            return new DefaultCentralAuthenticationService(centralAuthenticationServiceContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CentralAuthenticationServiceContext centralAuthenticationServiceContext(@Qualifier(value="defaultPrincipalResolver") PrincipalResolver principalResolver, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="protocolTicketCipherExecutor") CipherExecutor cipherExecutor, @Qualifier(value="principalFactory") PrincipalFactory principalFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="registeredServiceAccessStrategyEnforcer") AuditableExecution registeredServiceAccessStrategyEnforcer, @Qualifier(value="serviceMatchingStrategy") ServiceMatchingStrategy serviceMatchingStrategy, @Qualifier(value="globalAuthenticationPolicy") AuthenticationPolicy authenticationPolicy, @Qualifier(value="casTicketRegistryLockRepository") LockRepository casTicketRegistryLockRepository, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext) {
            return ((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)((CentralAuthenticationServiceContext.CentralAuthenticationServiceContextBuilder)CentralAuthenticationServiceContext.builder().authenticationServiceSelectionPlan(authenticationServiceSelectionPlan)).lockRepository(casTicketRegistryLockRepository)).cipherExecutor(cipherExecutor)).principalFactory(principalFactory)).ticketRegistry(ticketRegistry)).ticketFactory(ticketFactory)).registeredServiceAccessStrategyEnforcer(registeredServiceAccessStrategyEnforcer)).serviceMatchingStrategy(serviceMatchingStrategy)).applicationContext(applicationContext)).servicesManager(servicesManager)).authenticationPolicy(authenticationPolicy)).principalResolver(principalResolver)).tenantExtractor(tenantExtractor)).build();
        }
    }

    @Configuration(value="CasCorePolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCorePolicyConfiguration {
        CasCorePolicyConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"casCoreAuthenticationServiceSelectionStrategyConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationServiceSelectionStrategyConfigurer casCoreAuthenticationServiceSelectionStrategyConfigurer() {
            return plan -> plan.registerStrategy((AuthenticationServiceSelectionStrategy)new DefaultAuthenticationServiceSelectionStrategy());
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceMatchingStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceMatchingStrategy serviceMatchingStrategy(@Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultServiceMatchingStrategy(servicesManager);
        }

        @Bean
        @ConditionalOnMissingBean(name={"globalAuthenticationPolicy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationPolicy globalAuthenticationPolicy(CasConfigurationProperties casProperties) {
            if (casProperties.getAuthn().getPolicy().isRequiredHandlerAuthenticationPolicyEnabled()) {
                LOGGER.trace("Applying configuration for Required Handler Authentication Policy");
                return (AuthenticationPolicy & Serializable)(authentication, handlers, applicationContext, context) -> {
                    RegisteredService registeredService = (RegisteredService)context.get(RegisteredService.class.getName());
                    Set requiredHandlers = registeredService.getAuthenticationPolicy().getRequiredAuthenticationHandlers();
                    LOGGER.debug("Required authentication handlers for this service [{}] are [{}]", (Object)registeredService.getName(), (Object)requiredHandlers);
                    boolean success = requiredHandlers.stream().allMatch(required -> authentication.getSuccesses().containsKey(required));
                    return AuthenticationPolicyExecutionResult.success((boolean)success);
                };
            }
            return AuthenticationPolicy.alwaysSatisfied();
        }
    }
}

