/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.panels;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.ui.commons.MapChoiceRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxNumberFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.common.lib.form.FormProperty;
import org.apache.syncope.common.lib.form.FormPropertyValue;
import org.apache.syncope.common.lib.form.SyncopeForm;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.PatternValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeFormPanel<F extends SyncopeForm>
extends Panel {
    private static final long serialVersionUID = -8847854414429745216L;
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeFormPanel.class);

    public SyncopeFormPanel(String id, F form) {
        super(id);
        ListModel model = new ListModel(new ArrayList());
        ((List)model.getObject()).addAll(form.getProperties());
        ListView<FormProperty> propView = new ListView<FormProperty>("propView", (IModel)model){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<FormProperty> item) {
                AbstractFieldPanel field;
                final FormProperty prop = (FormProperty)item.getModelObject();
                String label = StringUtils.isBlank((CharSequence)prop.getName()) ? prop.getId() : prop.getName();
                switch (prop.getType()) {
                    case Boolean: {
                        field = new AjaxCheckBoxPanel("value", label, (IModel<Boolean>)new PropertyModel<Boolean>(this, (Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(modelObject, expression);
                            }

                            public Boolean getObject() {
                                return BooleanUtils.toBoolean((String)prop.getValue());
                            }

                            public void setObject(Boolean object) {
                                prop.setValue(BooleanUtils.toStringTrueFalse((Boolean)object));
                            }
                        }, false);
                        break;
                    }
                    case Date: {
                        final FastDateFormat formatter = StringUtils.isBlank((CharSequence)prop.getDatePattern()) ? FastDateFormat.getInstance() : FastDateFormat.getInstance((String)prop.getDatePattern());
                        PropertyModel<Date> dateModel = new PropertyModel<Date>(this, (Object)prop, "value"){
                            private static final long serialVersionUID = -3743432456095828573L;
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(modelObject, expression);
                            }

                            public Date getObject() {
                                try {
                                    return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : formatter.parse(prop.getValue());
                                }
                                catch (ParseException e) {
                                    LOG.error("Unparsable date: {}", (Object)prop.getValue(), (Object)e);
                                    return null;
                                }
                            }

                            public void setObject(Date object) {
                                Optional.ofNullable(object).ifPresent(date -> prop.setValue(formatter.format(date)));
                            }
                        };
                        if (Strings.CI.contains((CharSequence)prop.getDatePattern(), (CharSequence)"H")) {
                            field = new AjaxDateTimeFieldPanel("value", label, (IModel<Date>)dateModel, formatter);
                            break;
                        }
                        field = new AjaxDateFieldPanel("value", label, (IModel<Date>)dateModel, formatter);
                        break;
                    }
                    case Enum: {
                        field = new AjaxDropDownChoicePanel<String>("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false).setChoiceRenderer(new MapChoiceRenderer(prop.getEnumValues().stream().collect(Collectors.toMap(FormPropertyValue::getKey, FormPropertyValue::getValue)))).setChoices(prop.getEnumValues().stream().map(FormPropertyValue::getKey).toList());
                        break;
                    }
                    case Dropdown: {
                        if (prop.isDropdownFreeForm()) {
                            field = new AjaxTextFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false);
                            field.setChoices(prop.getDropdownValues().stream().map(FormPropertyValue::getKey).toList());
                            break;
                        }
                        if (prop.isDropdownSingleSelection()) {
                            field = new AjaxDropDownChoicePanel<String>("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false).setChoiceRenderer(new MapChoiceRenderer(prop.getDropdownValues().stream().collect(Collectors.toMap(FormPropertyValue::getKey, FormPropertyValue::getValue)))).setChoices(prop.getDropdownValues().stream().map(FormPropertyValue::getKey).toList());
                            break;
                        }
                        field = new AjaxPalettePanel.Builder().setName(label).setRenderer(new MapChoiceRenderer(prop.getDropdownValues().stream().collect(Collectors.toMap(FormPropertyValue::getKey, FormPropertyValue::getValue)))).build("value", new IModel<List<String>>(){
                            private static final long serialVersionUID = 1015030402166681242L;
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public List<String> getObject() {
                                return Optional.ofNullable(prop.getValue()).map(v -> List.of(v.split(";"))).orElseGet(List::of);
                            }

                            public void setObject(List<String> object) {
                                prop.setValue((String)Optional.ofNullable(object).map(v -> String.join((CharSequence)";", v)).orElse(null));
                            }
                        }, (IModel<List<String>>)new ListModel(prop.getDropdownValues().stream().map(FormPropertyValue::getKey).toList()));
                        break;
                    }
                    case Long: {
                        field = new AjaxNumberFieldPanel.Builder<Long>().build("value", label, Long.class, (IModel<Long>)new PropertyModel<Long>(this, (Object)prop, "value"){
                            private static final long serialVersionUID = -7688359318035249200L;
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(modelObject, expression);
                            }

                            public Long getObject() {
                                return StringUtils.isBlank((CharSequence)prop.getValue()) ? null : Long.valueOf(NumberUtils.toLong((String)prop.getValue()));
                            }

                            public void setObject(Long object) {
                                prop.setValue(String.valueOf(object));
                            }
                        });
                        break;
                    }
                    case Password: {
                        field = new AjaxPasswordFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false).setResetPassword(false);
                        break;
                    }
                    case Binary: {
                        final PageReference pageRef = this.getPage().getPageReference();
                        field = new BinaryFieldPanel(this, "value", label, (IModel)new PropertyModel((Object)prop, "value"), prop.getMimeType(), prop.getId()){
                            private static final long serialVersionUID = -3268213909514986831L;
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(id, name, (IModel<String>)model, mimeType, fileKey);
                            }

                            @Override
                            protected PageReference getPageReference() {
                                return pageRef;
                            }
                        };
                        break;
                    }
                    default: {
                        field = new AjaxTextFieldPanel("value", label, (IModel<String>)new PropertyModel((Object)prop, "value"), false);
                        Optional.ofNullable(prop.getStringRegEx()).ifPresent(re -> ((AjaxTextFieldPanel)field).addValidator((IValidator<? super String>)new PatternValidator(re)));
                    }
                }
                ((AbstractFieldPanel)field).setReadOnly(!prop.isWritable());
                if (prop.isRequired()) {
                    field.addRequiredLabel();
                }
                item.add(new Component[]{field});
            }
        };
        this.add(new Component[]{propView.setReuseItems(true)});
    }
}

