/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.principal.Principal;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public interface Authentication
extends Serializable {
    public Principal getPrincipal();

    public ZonedDateTime getAuthenticationDate();

    public Map<String, List<Object>> getAttributes();

    public void addAttribute(String var1, Object var2);

    public boolean containsAttribute(String var1);

    public List<Credential> getCredentials();

    public List<MessageDescriptor> getWarnings();

    public Map<String, AuthenticationHandlerExecutionResult> getSuccesses();

    public Map<String, Throwable> getFailures();

    public void updateAttributes(Authentication var1);

    public void replaceAttributes(Authentication var1);

    public boolean isEqualTo(Authentication var1);

    public <T> T getSingleValuedAttribute(String var1, Class<T> var2);

    default public Object getSingleValuedAttribute(String name) {
        return this.getSingleValuedAttribute(name, Object.class);
    }
}

